/*
 * Decompiled with CFR 0.152.
 */
package com.ksptooi.uac.commons.stream;

import java.io.IOException;
import java.io.InputStream;

public class ProgressInputStream
extends InputStream {
    private InputStream is = null;
    private final long total;
    private long current;

    public ProgressInputStream(long total, InputStream is) {
        this.is = is;
        this.total = total;
    }

    @Override
    public int read() throws IOException {
        int read = this.is.read();
        this.update(read);
        return read;
    }

    private void update(long length) {
        this.current += length;
        this.updateProgress("\u5904\u7406\u4e2d", this.current, this.total - 1L);
    }

    private void updateProgress(String title, long progress, long total) {
        int width = 50;
        long percent = progress * 100L / total;
        long completeLength = progress * (long)width / total;
        StringBuilder sb = new StringBuilder();
        sb.append(title).append(" ");
        sb.append('[');
        int i = 0;
        while ((long)i < completeLength) {
            sb.append('=');
            ++i;
        }
        sb.append('>');
        for (long i2 = completeLength; i2 < (long)width; ++i2) {
            sb.append(' ');
        }
        sb.append(']');
        sb.append(String.format(" %d%%", percent));
        sb.append(" ").append(progress).append(" of ").append(total);
        System.out.print("\r" + sb.toString());
    }

    @Override
    public int read(byte[] b) throws IOException {
        int read = this.is.read(b);
        this.update(read);
        return read;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read = this.is.read(b, off, len);
        this.update(read);
        return read;
    }

    @Override
    public long skip(long n) throws IOException {
        return this.is.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.is.available();
    }

    @Override
    public void close() throws IOException {
        System.out.print("\r\n");
        this.is.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.is.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.is.reset();
    }

    @Override
    public boolean markSupported() {
        return this.is.markSupported();
    }
}

