/*
 * Decompiled with CFR 0.152.
 */
package com.ksptooi.uac.core.plugins;

import com.google.inject.Inject;
import com.ksptooi.uac.ApplicationOld;
import com.ksptooi.uac.commons.JarFileFilter;
import com.ksptooi.uac.core.annatatiotion.PluginEntry;
import com.ksptooi.uac.core.entities.InstalledPlugin;
import com.ksptooi.uac.core.entities.JarPlugin;
import com.ksptooi.uac.core.plugins.Plugin;
import com.ksptooi.uac.core.plugins.PluginLoader;
import com.ksptooi.uac.core.processor.Processor;
import com.ksptooi.uac.core.processor.ProcessorDispatcher;
import com.ksptooi.uac.core.processor.ProcessorScanner;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JarPluginLoader
implements PluginLoader {
    private final Logger logger = LoggerFactory.getLogger(JarPluginLoader.class);
    private final List<InstalledPlugin> loadedPlugins = new ArrayList<InstalledPlugin>();
    @Inject
    private ProcessorDispatcher processorDispatcher;
    @Inject
    private ProcessorScanner scanner;

    public Map<String, Plugin> getPlugin(String directoryPath) {
        this.logger.info("\u6b63\u5728\u83b7\u53d6\u63d2\u4ef6...");
        File dir = new File(directoryPath);
        if (!dir.exists()) {
            this.logger.info("\u83b7\u53d6\u51fa\u9519,\u8def\u5f84\"" + directoryPath + "\"\u4e0d\u5b58\u5728!");
            return new HashMap<String, Plugin>();
        }
        if (!dir.isDirectory()) {
            this.logger.info("\u83b7\u53d6\u51fa\u9519,\u8def\u5f84\"" + directoryPath + "\"\u4e0d\u662f\u6587\u4ef6\u5939!");
            return new HashMap<String, Plugin>();
        }
        File[] jarFiles = dir.listFiles(new JarFileFilter());
        if (jarFiles == null) {
            return new HashMap<String, Plugin>();
        }
        HashMap<String, Plugin> pluginList = new HashMap<String, Plugin>();
        for (File jar : jarFiles) {
            try {
                URL url = jar.toURI().toURL();
                URLClassLoader loader = new URLClassLoader(new URL[]{url});
                Reflections packageReflections = new Reflections((Configuration)new ConfigurationBuilder().addUrls(new URL[]{url}).addClassLoaders(new ClassLoader[]{loader}));
                Set entrySet = packageReflections.getTypesAnnotatedWith(PluginEntry.class);
                if (entrySet.size() != 1) {
                    this.logger.info("\u5c1d\u8bd5\u83b7\u53d6" + jar.getName() + "\u65f6\u51fa\u9519. \u671f\u671b\u7684Entry\u4e3a1 \u5f53\u524d\u4e3a:" + entrySet.size());
                    continue;
                }
                Class entry = (Class)entrySet.iterator().next();
                Plugin pluginEntry = (Plugin)entry.newInstance();
                this.logger.info("\u5df2\u83b7\u53d6:" + jar.getName() + "::" + entry.getAnnotation(PluginEntry.class).name() + "[" + entry.getAnnotation(PluginEntry.class).version() + "]");
                pluginList.put(entry.getAnnotation(PluginEntry.class).name(), pluginEntry);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return pluginList;
    }

    public void install(Map<String, Plugin> pluginMap) {
        this.logger.info("\u6b63\u5728\u52a0\u8f7d\u63d2\u4ef6...");
        for (Map.Entry<String, Plugin> item : pluginMap.entrySet()) {
            this.logger.info("\u52a0\u8f7d:" + item.getKey());
            ApplicationOld.injector.injectMembers((Object)item.getValue());
            item.getValue().onEnabled();
        }
    }

    @Override
    public List<JarPlugin> getJarPlugin(String directoryPath) {
        return this.getJarPlugin(new File(directoryPath));
    }

    @Override
    public List<JarPlugin> getJarPlugin(File dirFile) {
        this.logger.info("\u6b63\u5728\u83b7\u53d6\u63d2\u4ef6...");
        ArrayList<JarPlugin> retList = new ArrayList<JarPlugin>();
        if (!dirFile.exists()) {
            this.logger.info("\u83b7\u53d6\u51fa\u9519,\u8def\u5f84\"" + String.valueOf(dirFile) + "\"\u4e0d\u5b58\u5728!");
            return retList;
        }
        if (!dirFile.isDirectory()) {
            this.logger.info("\u83b7\u53d6\u51fa\u9519,\u8def\u5f84\"" + String.valueOf(dirFile) + "\"\u4e0d\u662f\u6587\u4ef6\u5939!");
            return retList;
        }
        File[] jarFiles = dirFile.listFiles(new JarFileFilter());
        if (jarFiles == null) {
            return retList;
        }
        for (File jar : jarFiles) {
            try {
                URL url = jar.toURI().toURL();
                URLClassLoader loader = new URLClassLoader(new URL[]{url});
                Reflections packageReflections = new Reflections((Configuration)new ConfigurationBuilder().addUrls(new URL[]{url}).addClassLoaders(new ClassLoader[]{loader}));
                Set entrySet = packageReflections.getTypesAnnotatedWith(PluginEntry.class);
                if (entrySet.size() != 1) {
                    this.logger.info("\u5c1d\u8bd5\u83b7\u53d6" + jar.getName() + "\u65f6\u51fa\u9519. \u671f\u671b\u7684Entry\u4e3a1 \u5f53\u524d\u4e3a:" + entrySet.size());
                    continue;
                }
                Class entry = (Class)entrySet.iterator().next();
                Plugin pluginEntry = (Plugin)entry.newInstance();
                String pluginName = entry.getAnnotation(PluginEntry.class).name();
                String pluginVersion = entry.getAnnotation(PluginEntry.class).version();
                JarPlugin jarPlugin = new JarPlugin();
                jarPlugin.setJarFile(jar);
                jarPlugin.setPluginName(pluginName);
                jarPlugin.setPluginVersion(pluginVersion);
                jarPlugin.setEntry(pluginEntry);
                jarPlugin.setProcessors(this.scanner.scan(url, loader));
                this.logger.info("\u5df2\u83b7\u53d6:{}-{}[{}] \u5904\u7406\u5668\u6570\u91cf:{}", new Object[]{jar.getName(), pluginName, pluginVersion, jarPlugin.getProcessors().size()});
                retList.add(jarPlugin);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return retList;
    }

    @Override
    public boolean install(JarPlugin jarPlugin) {
        Plugin entry = jarPlugin.getEntry();
        Map<String, Processor> processors = jarPlugin.getProcessors();
        this.logger.info("\u52a0\u8f7d:{}[{}]", (Object)jarPlugin.getPluginName(), (Object)jarPlugin.getPluginVersion());
        InstalledPlugin installed = new InstalledPlugin();
        installed.setName(jarPlugin.getPluginName());
        installed.setVersion(jarPlugin.getPluginVersion());
        installed.setEntry(jarPlugin.getEntry());
        ArrayList<String> processNameList = new ArrayList<String>();
        installed.setProcessors(processNameList);
        ApplicationOld.injector.injectMembers((Object)entry);
        entry.onEnabled();
        this.loadedPlugins.add(installed);
        for (Map.Entry<String, Processor> item : processors.entrySet()) {
            this.logger.info("\u6ce8\u518c\u63d2\u4ef6\u5904\u7406\u5668:{}", (Object)item.getKey());
            this.processorDispatcher.register(item.getKey(), item.getValue());
            processNameList.add(item.getKey());
        }
        return true;
    }

    @Override
    public void install(List<JarPlugin> jarPlugins) {
        for (JarPlugin item : jarPlugins) {
            this.install(item);
        }
    }

    @Override
    public List<InstalledPlugin> getPluginList() {
        return this.loadedPlugins;
    }

    @Override
    public void remove(String pluginName) {
        for (int i = 0; i < this.loadedPlugins.size(); ++i) {
            if (!this.loadedPlugins.get(i).getName().equals(pluginName)) continue;
            this.loadedPlugins.remove(i);
            break;
        }
    }
}

