/*
 * Decompiled with CFR 0.152.
 */
package com.ksptooi.uac.core.processor;

import com.google.inject.Inject;
import com.ksptooi.uac.commons.ReflectUtils;
import com.ksptooi.uac.core.annatatiotion.CommandMapping;
import com.ksptooi.uac.core.annatatiotion.Param;
import com.ksptooi.uac.core.entities.CliCommand;
import com.ksptooi.uac.core.entities.Command;
import com.ksptooi.uac.core.processor.CmdProcessRegisterWrapper;
import com.ksptooi.uac.core.processor.Processor;
import com.ksptooi.uac.core.processor.ProcessorDispatcher;
import com.ksptooi.uac.core.service.CommandService;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmdAnnotationDispatcher
extends CmdProcessRegisterWrapper {
    private final Logger logger = LoggerFactory.getLogger(ProcessorDispatcher.class);
    @Inject
    private CommandService service;

    private Method getMethodByCommandMapping(Class<?> clazz, String inCommand, int prmNumber) {
        Method[] methodByAnnotation = ReflectUtils.getMethodByAnnotation(clazz, CommandMapping.class);
        if (methodByAnnotation.length < 1) {
            return null;
        }
        Method minPrmMethod = null;
        for (Method item : methodByAnnotation) {
            String[] values;
            for (String value : values = item.getAnnotation(CommandMapping.class).value()) {
                if (!value.equals(inCommand)) continue;
                if (minPrmMethod != null && minPrmMethod.getParameterCount() > item.getParameterCount()) {
                    minPrmMethod = item;
                }
                if (minPrmMethod == null) {
                    minPrmMethod = item;
                }
                if (item.getParameterCount() != prmNumber) continue;
                return item;
            }
        }
        if (minPrmMethod != null) {
            return minPrmMethod;
        }
        return null;
    }

    private Object[] assemblyParams(Method method, Object[] innerParam, List<String> stringParam) {
        Class<?>[] parameterTypes;
        if (stringParam == null) {
            stringParam = new ArrayList<String>();
        }
        if ((parameterTypes = method.getParameterTypes()).length - innerParam.length > stringParam.size()) {
            return null;
        }
        Object[] params = new Object[method.getParameterCount()];
        int paramCount = 0;
        for (int i = 0; i < parameterTypes.length; ++i) {
            boolean isInnerParam = false;
            for (Object item : innerParam) {
                if (!parameterTypes[i].isInstance(item)) continue;
                params[i] = item;
                isInnerParam = true;
            }
            try {
                if (isInnerParam) continue;
                params[i] = stringParam.get(paramCount);
                ++paramCount;
                continue;
            }
            catch (IndexOutOfBoundsException e) {
                return null;
            }
        }
        return params;
    }

    private String[] getParamNameByAnnotation(Method method) {
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        ArrayList<String> retString = new ArrayList<String>();
        Annotation[][] annotationArray = parameterAnnotations;
        int n = annotationArray.length;
        for (int i = 0; i < n; ++i) {
            Annotation[] anno;
            for (Annotation item : anno = annotationArray[i]) {
                if (!(item instanceof Param)) continue;
                retString.add(((Param)item).value());
            }
        }
        return retString.toArray(new String[0]);
    }

    @Override
    public void publish(CliCommand inVo) {
        Map<String, Processor> processorMap = this.getProcessorMap();
        Command commandByName = this.service.getCommandByName(inVo.getName());
        if (commandByName == null) {
            super.publish(inVo);
            return;
        }
        Processor processor = processorMap.get(commandByName.getExecutorName());
        if (processor == null) {
            super.publish(inVo);
            return;
        }
        Method targetMethod = this.getMethodByCommandMapping(processor.getClass(), inVo.getName(), inVo.getParameter().size());
        if (targetMethod == null) {
            super.publish(inVo);
            return;
        }
        Object[] params = this.assemblyParams(targetMethod, new Object[]{inVo, commandByName}, inVo.getParameter());
        if (params == null) {
            this.logger.info("\u6307\u4ee4\u53c2\u6570\u4e0d\u8db3>{}", (Object)Arrays.toString(this.getParamNameByAnnotation(targetMethod)));
            return;
        }
        try {
            targetMethod.invoke((Object)processor, params);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }
}

