/*
 * Decompiled with CFR 0.152.
 */
package com.ksptooi.uac.core.processor;

import com.google.inject.Inject;
import com.ksptooi.uac.ApplicationOld;
import com.ksptooi.uac.core.entities.CliCommand;
import com.ksptooi.uac.core.entities.Command;
import com.ksptooi.uac.core.processor.Processor;
import com.ksptooi.uac.core.processor.ProcessorDispatcher;
import com.ksptooi.uac.core.service.CommandService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmdProcessDispatcher
implements ProcessorDispatcher {
    private final Logger logger = LoggerFactory.getLogger(CmdProcessDispatcher.class);
    private final HashMap<String, Processor> processorMap = new HashMap();
    private Processor activity = null;
    @Inject
    private CommandService service;

    @Override
    public void register(Map<String, Processor> procMap) {
        for (Map.Entry<String, Processor> item : procMap.entrySet()) {
            this.register(item.getKey(), item.getValue());
        }
    }

    @Override
    public boolean register(String listenerName, Processor listener) {
        if (this.processorMap.get(listenerName) != null) {
            this.logger.warn("\u5904\u7406\u5668\u6ce8\u518c\u5931\u8d25,\u8be5\u5904\u7406\u5668\u540d\u79f0\u5df2\u88ab\u5360\u7528:{}", (Object)listenerName);
            return false;
        }
        ApplicationOld.injector.injectMembers((Object)listener);
        this.logger.info("\u5df2\u6ce8\u518c\u547d\u4ee4\u5904\u7406\u5668:" + listenerName);
        this.processorMap.put(listenerName, listener);
        listener.onInit();
        return true;
    }

    @Override
    public boolean remove(String procName) {
        Processor remove = this.processorMap.remove(procName);
        return remove != null;
    }

    @Override
    public void publish(CliCommand inVo) {
        Command commandByName = this.service.getCommandByName(inVo.getName());
        if (commandByName == null) {
            this.logger.info("{} \u4e0d\u662f\u4e00\u4e2aUAC\u6307\u4ee4.", (Object)inVo.getName());
            return;
        }
        Processor proc = this.processorMap.get(commandByName.getExecutorName());
        if (proc == null) {
            this.logger.info("{} \u6ca1\u6709\u5bf9\u5e94\u7684\u6307\u4ee4\u5904\u7406\u5668.", (Object)inVo.getName());
            return;
        }
        proc.onCommand(inVo, commandByName);
    }

    @Override
    public void getActivity(Processor listener) {
        this.activity = listener;
    }

    @Override
    public void removeActivity() {
        this.activity = null;
    }

    protected void setActivity(Processor in) {
        this.activity = in;
    }

    @Override
    public List<String> getRegisteredProcessor() {
        Set<String> strings = this.processorMap.keySet();
        return new ArrayList<String>(strings);
    }

    public Map<String, Processor> getProcessorMap() {
        return this.processorMap;
    }
}

