/*
 * Decompiled with CFR 0.152.
 */
package com.ksptooi.uac.core.service;

import com.google.inject.Inject;
import com.ksptooi.uac.ApplicationOld;
import com.ksptooi.uac.core.mapper.DatabaseMapper;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseService {
    @Inject
    private DatabaseMapper mapper;
    private final Logger logger = LoggerFactory.getLogger(DatabaseService.class);

    public void trim() {
        try {
            this.mapper.trim();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void export(Path path) {
        if (Files.isDirectory(path, new LinkOption[0])) {
            this.logger.info("\u8def\u5f84\u662f\u6587\u4ef6\u5939:{}", (Object)path.toString());
            return;
        }
        if (Files.exists(path, new LinkOption[0])) {
            this.logger.info("\u6587\u4ef6\u5df2\u5b58\u5728:{}", (Object)path.toString());
            return;
        }
        this.mapper.export(path.toString());
        if (Files.exists(path, new LinkOption[0])) {
            this.logger.info("\u5df2\u5bfc\u51fa\u5230:{}", (Object)path.toAbsolutePath().toString());
            return;
        }
        this.logger.info("\u5bfc\u51fa\u6570\u636e\u5e93\u5931\u8d25!");
    }

    public void dbImport(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            this.logger.info("\u6587\u4ef6\u4e0d\u5b58\u5728:{}", (Object)path.toString());
            return;
        }
        this.mapper.dropAll();
        this.mapper.dbImport(path.toAbsolutePath().toString());
        this.initTableStructure();
        this.logger.info("\u6267\u884c\u5b8c\u6210");
    }

    public void initTableStructure() {
        Logger logger = ApplicationOld.getLogger();
        Integer command = this.mapper.getTable("COMMAND");
        Integer document = this.mapper.getTable("DOCUMENT");
        if (command > 0 && document > 0) {
            logger.info("\u6570\u636e\u5e93\u9884\u68c0\u901a\u8fc7! \u8868\u7ed3\u6784\u5b8c\u6574.");
            return;
        }
        logger.info("\u6b63\u5728\u521d\u59cb\u5316\u6570\u636e\u5e93..");
        if (command < 1) {
            logger.info("\u6784\u5efa\u8868::COMMAND");
            this.mapper.createCommandTable();
        }
        if (document < 1) {
            logger.info("\u6784\u5efa\u8868::DOCUMENT");
            this.mapper.createDocumentTable();
        }
        logger.info("\u6570\u636e\u5e93\u521d\u59cb\u5316\u5b8c\u6210.");
    }
}

