/*
 * Decompiled with CFR 0.152.
 */
package com.ksptooi.uac.extendsbuildin.processor;

import com.ksptooi.uac.core.annatatiotion.CommandMapping;
import com.ksptooi.uac.core.annatatiotion.Param;
import com.ksptooi.uac.core.annatatiotion.Processor;
import com.ksptooi.uac.core.entities.CliCommand;
import com.ksptooi.uac.core.entities.Command;
import com.ksptooi.uac.core.entities.Document;
import com.ksptooi.uac.core.mapper.DocumentMapper;
import com.ksptooi.uac.core.processor.ProcessorAdapter;
import com.ksptooi.uac.core.service.DatabaseService;
import com.ksptooi.uac.core.service.DocumentService;
import com.ksptooi.uac.extendsbuildin.service.CacheService;
import jakarta.inject.Inject;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Processor(value="CacheProcessor")
public class CacheProcessor
extends ProcessorAdapter {
    private final Logger logger = LoggerFactory.getLogger(CacheProcessor.class);
    @Inject
    private DocumentService documentService;
    @Inject
    private CacheService cacheService;
    @Inject
    private DocumentMapper mapper;
    @Inject
    private DatabaseService dbService;

    @Override
    public String[] defaultCommand() {
        return new String[]{"c", "c list", "c get", "c rm", "c output"};
    }

    @CommandMapping(value={"c get"})
    public void cacheGet(@Param(value="key") String key) {
        this.cacheService.saveAsDocument(Paths.get("E:\\Services", new String[0]), UUID.randomUUID().toString());
    }

    @CommandMapping(value={"c rm"})
    public void cacheRemove(@Param(value="key") String key) {
        Document dom = this.documentService.getDocumentByName(key);
        if (dom == null) {
            this.logger.info("\u6307\u5b9a\u7684\u8d44\u6e90\u4e0d\u5b58\u5728!");
            return;
        }
        this.documentService.removeById(dom.getDocId());
        this.dbService.trim();
    }

    @CommandMapping(value={"c"})
    public void cache(@Param(value="path") String filePath) {
        this.cache(UUID.randomUUID().toString(), filePath);
    }

    @CommandMapping(value={"c"})
    public void cache(@Param(value="key") String key, @Param(value="path") String filePath) {
        Path path = Paths.get(filePath, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            this.logger.info("\u8def\u5f84:{} \u4e0d\u5b58\u5728!", (Object)path);
            return;
        }
        this.cacheService.saveAsDocument(path, key);
    }

    @CommandMapping(value={"c list"})
    public void cacheList() {
        this.cacheService.listAll();
    }

    @Override
    public void onCommand(CliCommand preparedCommand, Command command) {
        String name = preparedCommand.getName();
        if (name.equals("c output")) {
            List<String> parameter = preparedCommand.getParameter();
            if (parameter.size() < 1) {
                Path path = this.cacheService.getOutputPath();
                if (path == null) {
                    this.logger.info("\u6ca1\u6709\u8bbe\u5b9a\u8f93\u51fa\u8def\u5f84");
                    return;
                }
                this.logger.info("\u5f53\u524d\u8f93\u51fa\u8def\u5f84:{}", (Object)path.toString());
                return;
            }
            String paths = parameter.get(0);
            Path path = Paths.get(paths, new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                this.logger.info("\u8f93\u51fa\u8def\u5f84\u5728\u6587\u4ef6\u7cfb\u7edf\u4e0a\u4e0d\u5b58\u5728. {}", (Object)paths);
                return;
            }
            if (!Files.isDirectory(path, new LinkOption[0])) {
                this.logger.info("\u8f93\u51fa\u8def\u5f84\u4e0d\u662f\u4e00\u4e2a\u6587\u4ef6\u5939. {}", (Object)paths);
                return;
            }
            this.cacheService.setOutputPath(paths);
        }
    }
}

