/*
 * Decompiled with CFR 0.152.
 */
package com.ksptooi.uac.extendsbuildin.service;

import com.alibaba.fastjson.JSON;
import com.google.gson.Gson;
import com.google.inject.Inject;
import com.ksptooi.uac.commons.CommandLineTable;
import com.ksptooi.uac.commons.Metadata;
import com.ksptooi.uac.core.entities.Command;
import com.ksptooi.uac.core.entities.Document;
import com.ksptooi.uac.core.service.CommandService;
import com.ksptooi.uac.core.service.DocumentService;
import com.ksptooi.uac.extendsbuildin.entities.ApplicationData;
import com.ksptooi.uac.extendsbuildin.entities.PackLibrary;
import com.ksptooi.uac.extendsbuildin.enums.BuildIn;
import com.ksptooi.uac.extendsbuildin.enums.DocumentType;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationService {
    private final Logger logger = LoggerFactory.getLogger(ApplicationService.class);
    @Inject
    private DocumentService service;
    @Inject
    private CommandService commandService;
    @Inject
    private DocumentService documentService;
    private final String packLibrayKey = "#pack_libray";

    public void setPackLib(String name, String path) {
        PackLibrary library = new PackLibrary();
        ArrayList<PackLibrary> libraryList = new ArrayList<PackLibrary>();
        if (name == null) {
            library.setName("\u8f6f\u4ef6\u5305\u76ee\u5f55");
        }
        library.setPath(path);
        libraryList.add(library);
        Document document = this.service.getDocumentByName(this.packLibrayKey);
        if (document == null) {
            document = this.service.createDocument(this.packLibrayKey);
        }
        document.setMetadata(new Gson().toJson(libraryList));
        this.service.update(document);
    }

    public void showPackLibs() {
        if (!this.service.hasDocument(this.packLibrayKey)) {
            this.logger.info("\u5f53\u524d\u6ca1\u6709\u8bbe\u7f6e\u8f6f\u4ef6\u5305\u57fa\u51c6\u76ee\u5f55");
            return;
        }
        Document commandByName = this.service.getDocumentByName(this.packLibrayKey);
        List list = JSON.parseArray((String)commandByName.getMetadata(), PackLibrary.class);
        System.out.println("\u5f53\u524d\u8f6f\u4ef6\u5305\u76ee\u5f55");
        for (PackLibrary item : list) {
            System.out.println(item.getName() + "--" + item.getPath());
        }
    }

    public void clearLibs() {
        if (!this.service.hasDocument(this.packLibrayKey)) {
            this.logger.info("\u5f53\u524d\u6ca1\u6709\u8bbe\u7f6e\u8f6f\u4ef6\u5305\u57fa\u51c6\u76ee\u5f55");
            return;
        }
        Document commandByName = this.service.getDocumentByName(this.packLibrayKey);
        commandByName.setMetadata("[]");
        this.service.update(commandByName);
        this.logger.info("\u8f6f\u4ef6\u5305\u57fa\u51c6\u76ee\u5f55\u5df2\u88ab\u6e05\u9664");
    }

    public void saveAsDocument(Command app) {
        ApplicationData appData = Metadata.asAppdata(app);
        Document document = this.documentService.createDocument(appData.getMd5(), DocumentType.APP_ARCHIVE.getName());
        document.setDescription("archived:" + appData.getPath());
        try {
            int length;
            InputStream fis = Files.newInputStream(Paths.get(appData.getPath(), new String[0]), new OpenOption[0]);
            byte[] read = new byte[512000];
            while ((length = fis.read(read)) >= 1) {
                document.appendBinaryData(read, length);
            }
            this.documentService.update(document);
            appData.setDocumentName(appData.getMd5());
            app.setMetadata(JSON.toJSONString((Object)appData));
            this.commandService.update(app);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Command appInstall(String name, String path) {
        if (this.commandService.hasCommand(name)) {
            this.logger.info("\u5e94\u7528\u5b89\u88c5\u5931\u8d25,\u6307\u4ee4\"" + name + "\"\u5df2\u88ab\u5360\u7528");
            return null;
        }
        path = path.replace("\"", "");
        boolean exists = Files.exists(Paths.get(path, new String[0]), new LinkOption[0]);
        File file = new File(path);
        if (!exists) {
            this.logger.info("\u5e94\u7528\u5b89\u88c5\u5931\u8d25,\u63d0\u4f9b\u7684Path\u4e0d\u6b63\u786e! \"" + path + "\"");
            return null;
        }
        ApplicationData data = new ApplicationData();
        data.setPath(path);
        data.setFileName(file.getName());
        data.setDirectory(file.isDirectory());
        data.setLength(file.length());
        if (!file.isDirectory()) {
            try {
                FileInputStream fis = new FileInputStream(file);
                data.setMd5(DigestUtils.md5Hex((InputStream)fis));
                fis.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        Command insert = new Command();
        insert.setName(name);
        insert.setExecutorName(BuildIn.APP_RUNNER.getProcessorName());
        insert.setMetadata(new Gson().toJson((Object)data));
        this.commandService.insert(insert);
        this.logger.info("\u5e94\u7528\u5b89\u88c5\u5b8c\u6210,\u6307\u4ee4\u4e3a: \"" + name + "\"");
        return insert;
    }

    public void appRemove(String name) {
        Document documentByName;
        Command commandByName = this.commandService.getCommandByName(name);
        if (commandByName == null) {
            this.logger.info("\u5e94\u7528\u79fb\u9664\u5931\u8d25,\u6307\u4ee4\"" + name + "\"\u4e0d\u5b58\u5728!");
            return;
        }
        ApplicationData appData = (ApplicationData)JSON.parseObject((String)commandByName.getMetadata(), ApplicationData.class);
        if (appData.getDocumentName() != null && (documentByName = this.documentService.getDocumentByName(appData.getDocumentName())) != null) {
            this.documentService.removeById(documentByName.getDocId());
            this.logger.info("\u5220\u9664\u5173\u8054\u5f52\u6863:{}", (Object)appData.getDocumentName());
        }
        this.commandService.removeById("" + commandByName.getCmdId());
        this.logger.info("\u5e94\u7528\"" + name + "\"\u79fb\u9664\u6210\u529f!");
    }

    public void appShow() {
        List<Command> apps = this.commandService.getCommandByProcessorName(BuildIn.APP_RUNNER.getProcessorName());
        CommandLineTable cliTable = new CommandLineTable();
        cliTable.setShowVerticalLines(true);
        cliTable.setHeaders("Name", "Path");
        apps.forEach(item -> cliTable.addRow(item.getName(), JSON.parseObject((String)item.getMetadata()).getString("path")));
        cliTable.print();
    }
}

