/*
 * Decompiled with CFR 0.152.
 */
package com.ksptooi.uac.extendsbuildin.service;

import com.google.gson.Gson;
import com.ksptooi.uac.commons.CommandLineTable;
import com.ksptooi.uac.commons.ZipCompress;
import com.ksptooi.uac.commons.stream.MonitorInputStream;
import com.ksptooi.uac.commons.stream.ProgressInputStream;
import com.ksptooi.uac.core.entities.Document;
import com.ksptooi.uac.core.service.DocumentService;
import com.ksptooi.uac.extendsbuildin.entities.cache.CacheMetadata;
import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.mybatis.guice.transactional.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheService {
    private final Logger logger = LoggerFactory.getLogger(CacheService.class);
    private final Gson gson = new Gson();
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
    @Inject
    private DocumentService documentService;

    public void outputByKey(String key) {
        Path outputPath = this.getOutputPath();
        if (outputPath == null) {
            this.logger.info("\u83b7\u53d6\u8f93\u51fa\u8def\u5f84\u51fa\u9519!");
            return;
        }
        Document dom = this.documentService.getDocumentByName(key);
        if (dom == null) {
            this.logger.info("\u8d44\u6e90\u4e0d\u5b58\u5728!");
            return;
        }
        CacheMetadata md = (CacheMetadata)this.gson.fromJson(dom.getMetadata(), CacheMetadata.class);
        if (!md.isDirectory()) {
            File tgt = new File(outputPath.toFile(), md.getFileName());
            if (tgt.exists()) {
                this.logger.info("\u65e0\u6cd5\u521b\u5efa\u6587\u4ef6:{} \u5728\u6587\u4ef6\u7cfb\u7edf\u4e2d\u5b58\u5728\u91cd\u590d\u7684\u6587\u4ef6\u540d.", (Object)md.getFileName());
                return;
            }
            try {
                tgt.createNewFile();
                OutputStream os = Files.newOutputStream(tgt.toPath(), new OpenOption[0]);
                os.write(dom.getBinaryData());
                os.close();
                this.logger.info("\u5199\u51fa\u8def\u5f84:{}", (Object)tgt);
                return;
            }
            catch (IOException e) {
                e.printStackTrace();
                this.logger.info("\u6587\u4ef6\u7cfb\u7edf\u9519\u8bef!");
                return;
            }
        }
    }

    public void setOutputPath(String path) {
        Document document = this.documentService.getDocumentByName("cache_output_path");
        if (document == null) {
            document = this.documentService.createDocument("cache_output_path", "text_value");
        }
        document.setMetadata(path);
        this.documentService.update(document);
    }

    public Path getOutputPath() {
        Document dom = this.documentService.getDocumentByName("cache_output_path");
        if (dom == null) {
            return null;
        }
        Path path = Paths.get(dom.getMetadata(), new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            this.logger.info("\u8f93\u51fa\u8def\u5f84\u5728\u6587\u4ef6\u7cfb\u7edf\u4e0a\u4e0d\u5b58\u5728. {}", (Object)dom.getMetadata());
            return null;
        }
        if (!Files.isDirectory(path, new LinkOption[0])) {
            this.logger.info("\u8f93\u51fa\u8def\u5f84\u4e0d\u662f\u4e00\u4e2a\u6587\u4ef6\u5939. {}", (Object)dom.getMetadata());
            return null;
        }
        return path;
    }

    @Transactional
    public void saveAsDocument(Path path, String key) {
        this.logger.info("\u6b63\u5728\u5206\u914d\u7a7a\u95f4..");
        Document dom = this.documentService.createDocument(key, "cache_storage");
        try {
            long size = -1L;
            boolean isDirectory = false;
            if (Files.isDirectory(path, new LinkOption[0])) {
                ZipCompress compress = new ZipCompress(path);
                MonitorInputStream mis = new MonitorInputStream(compress.getInputStream());
                this.documentService.updateBinaryData(dom.getDocId(), mis);
                mis.close();
                isDirectory = true;
                size = mis.getTransferLength();
            }
            if (!Files.isDirectory(path, new LinkOption[0])) {
                size = Files.size(path);
                ProgressInputStream is = new ProgressInputStream(size, Files.newInputStream(path, new OpenOption[0]));
                this.documentService.updateBinaryData(dom.getDocId(), is);
                ((InputStream)is).close();
            }
            CacheMetadata data = new CacheMetadata();
            data.setFileName(path.getFileName().toString());
            data.setPath(path.toString());
            data.setLength(size);
            data.setDirectory(isDirectory);
            data.setCreateTime(new Date());
            data.setUpdateTime(new Date());
            dom.setMetadata(new Gson().toJson((Object)data));
            this.documentService.update(dom);
            this.logger.info("\u5df2\u4f20\u8f93 {} \u5b57\u8282", (Object)size);
            this.logger.info("\u8d44\u6e90\u6807\u8bc6:{}", (Object)dom.getName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void listAll() {
        List<Document> caches = this.documentService.getDocumentByType("cache_storage");
        CommandLineTable clTable = new CommandLineTable();
        clTable.setHeaders("Key", "FileName", "Size", "Directory", "Type", "CrateTime");
        clTable.setShowVerticalLines(true);
        caches.forEach(item -> {
            CacheMetadata metadata = (CacheMetadata)this.gson.fromJson(item.getMetadata(), CacheMetadata.class);
            String type = "File";
            if (metadata.isDirectory()) {
                type = "Archive";
            }
            clTable.addRow(item.getName(), metadata.getFileName(), metadata.getLength() / 1024L / 1024L + "MB", String.valueOf(metadata.isDirectory()), type, this.sdf.format(item.getCreateTime()));
        });
        clTable.print();
    }
}

