/*
 * Decompiled with CFR 0.152.
 */
package com.ksptooi.uac.extendsbuildin.service;

import com.google.inject.Inject;
import com.ksptooi.uac.ApplicationOld;
import com.ksptooi.uac.commons.CommandLineTable;
import com.ksptooi.uac.core.entities.Command;
import com.ksptooi.uac.core.mapper.CommandMapper;
import com.ksptooi.uac.core.processor.ProcessorDispatcher;
import java.text.SimpleDateFormat;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandOperateService {
    private final Logger logger = LoggerFactory.getLogger(ApplicationOld.class);
    @Inject
    private CommandMapper mapper;
    @Inject
    private ProcessorDispatcher processorDispatcher;

    public void listAll() {
        List<Command> commandList = this.mapper.getCommandList(new Command());
        CommandLineTable clTable = new CommandLineTable();
        clTable.setHeaders("Name", "Processor", "description", "metadata", "createTime");
        clTable.setShowVerticalLines(true);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        commandList.forEach(item -> clTable.addRow(item.getName(), item.getExecutorName(), item.getDescription(), "N/A", sdf.format(item.getCreateTime())));
        clTable.print();
    }

    public void refreshCommand() {
        List<String> registeredProcessor = this.processorDispatcher.getRegisteredProcessor();
        List<Command> commandList = this.mapper.getCommandList(new Command());
        for (Command item : commandList) {
            boolean existsProcessor = false;
            for (String procName : registeredProcessor) {
                if (!procName.equals(item.getProcessorName())) continue;
                existsProcessor = true;
                break;
            }
            if (existsProcessor) continue;
            this.logger.info("\u6e05\u9664\u65e0\u6548\u7684\u6307\u4ee4:{}->{}", (Object)item.getName(), (Object)item.getProcessorName());
            this.mapper.removeById("" + item.getCmdId());
        }
        this.logger.info("\u5237\u65b0\u6307\u4ee4\u6570\u636e\u5b8c\u6210");
    }
}

