/*
 * Decompiled with CFR 0.152.
 */
package com.ksptooi.uac.extendsbuildin.service;

import com.google.inject.Inject;
import com.ksptooi.uac.ApplicationOld;
import com.ksptooi.uac.commons.CommandLineTable;
import com.ksptooi.uac.core.entities.InstalledPlugin;
import com.ksptooi.uac.core.plugins.PluginLoader;
import com.ksptooi.uac.core.processor.ProcessorDispatcher;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public class PluginOperateService {
    @Inject
    private PluginLoader pluginLoader;
    @Inject
    private ProcessorDispatcher processorDispatcher;

    public void printPluginList() {
        List<InstalledPlugin> pluginList = this.pluginLoader.getPluginList();
        CommandLineTable cliTable = new CommandLineTable();
        cliTable.setShowVerticalLines(true);
        cliTable.setHeaders("pluginName", "version");
        pluginList.forEach(item -> cliTable.addRow(item.getName(), item.getVersion()));
        cliTable.print();
    }

    public void installAll() {
        this.pluginLoader.install(this.pluginLoader.getJarPlugin("plugins"));
    }

    public void uninstallAll() {
        Logger logger = ApplicationOld.getLogger();
        ArrayList<InstalledPlugin> pluginList = new ArrayList<InstalledPlugin>(this.pluginLoader.getPluginList());
        logger.info("\u6e05\u9664\u6ce8\u518c\u7684\u63d2\u4ef6\u5904\u7406\u5668");
        for (InstalledPlugin plugin : pluginList) {
            List<String> processors = plugin.getProcessors();
            for (String proc : processors) {
                logger.info("\u79fb\u9664\u5904\u7406\u5668:{}", (Object)proc);
                this.processorDispatcher.remove(proc);
            }
        }
        logger.info("\u6267\u884c\u63d2\u4ef6\u5378\u8f7d");
        for (InstalledPlugin plugin : pluginList) {
            plugin.getEntry().onDisable();
            this.pluginLoader.remove(plugin.getName());
            logger.info("\u5df2\u5378\u8f7d\u63d2\u4ef6:{}", (Object)plugin.getName());
        }
    }
}

