/*
 * Decompiled with CFR 0.152.
 */
package com.kttdevelopment.simplehttpserver.handler;

import com.kttdevelopment.simplehttpserver.ContextUtil;
import com.kttdevelopment.simplehttpserver.handler.ByteLoadingOption;
import com.kttdevelopment.simplehttpserver.handler.FileEntry;
import com.kttdevelopment.simplehttpserver.handler.FileHandlerAdapter;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;

class DirectoryEntry {
    private final File directory;
    private final FileHandlerAdapter adapter;
    private final ByteLoadingOption loadingOption;
    private final boolean isWalkthrough;
    private final Map<String, FileEntry> preloadedFiles;
    private final Path directoryPath;
    private final Map<Path, AtomicBoolean> watchService;

    DirectoryEntry(File directory, final FileHandlerAdapter adapter, final ByteLoadingOption loadingOption, boolean isWalkthrough) {
        block17: {
            block16: {
                this.preloadedFiles = new ConcurrentHashMap<String, FileEntry>();
                this.watchService = new ConcurrentHashMap<Path, AtomicBoolean>();
                this.directory = directory;
                this.adapter = adapter;
                this.loadingOption = loadingOption;
                this.isWalkthrough = isWalkthrough;
                this.directoryPath = directory.toPath();
                if (loadingOption != ByteLoadingOption.WATCHLOAD) break block16;
                if (!isWalkthrough) {
                    for (File file : Objects.requireNonNullElse(directory.listFiles(), new File[0])) {
                        if (file.isDirectory()) continue;
                        try {
                            this.preloadedFiles.put(ContextUtil.getContext(adapter.getName(file), true, false), new FileEntry(file, adapter, ByteLoadingOption.WATCHLOAD, true));
                        }
                        catch (UncheckedIOException uncheckedIOException) {
                            // empty catch block
                        }
                    }
                    try {
                        this.createWatchService(this.directoryPath, this.createWatchServiceConsumer(this.directoryPath));
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                } else {
                    try {
                        Files.walkFileTree(this.directoryPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                            @Override
                            public final FileVisitResult preVisitDirectory(Path path, BasicFileAttributes attrs) throws IOException {
                                DirectoryEntry.this.createWatchService(path, DirectoryEntry.this.createWatchServiceConsumer(path));
                                return FileVisitResult.CONTINUE;
                            }

                            @Override
                            public final FileVisitResult visitFile(Path path, BasicFileAttributes attrs) {
                                File file = path.toFile();
                                String relative = DirectoryEntry.this.directoryPath.relativize(path.getParent()).toString();
                                try {
                                    DirectoryEntry.this.preloadedFiles.put(ContextUtil.joinContexts(true, false, relative, adapter.getName(file)), new FileEntry(file, adapter, loadingOption, true));
                                }
                                catch (UncheckedIOException uncheckedIOException) {
                                    // empty catch block
                                }
                                return FileVisitResult.CONTINUE;
                            }
                        });
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
            }
            if (loadingOption != ByteLoadingOption.PRELOAD) break block17;
            if (!isWalkthrough) {
                File[] listFiles;
                for (File file : listFiles = Objects.requireNonNullElse(directory.listFiles(), new File[0])) {
                    if (file.isDirectory()) continue;
                    try {
                        this.preloadedFiles.put(ContextUtil.getContext(adapter.getName(file), true, false), new FileEntry(file, adapter, ByteLoadingOption.PRELOAD));
                    }
                    catch (UncheckedIOException uncheckedIOException) {
                        // empty catch block
                    }
                }
            } else {
                try {
                    Files.walkFileTree(this.directoryPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public final FileVisitResult visitFile(Path path, BasicFileAttributes attrs) {
                            File file = path.toFile();
                            String relative = DirectoryEntry.this.directoryPath.relativize(path.getParent()).toString();
                            try {
                                DirectoryEntry.this.preloadedFiles.put(ContextUtil.joinContexts(true, false, relative, adapter.getName(file)), new FileEntry(file, adapter, ByteLoadingOption.PRELOAD));
                            }
                            catch (RuntimeException runtimeException) {
                                // empty catch block
                            }
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        }
    }

    private void createWatchService(Path path, Consumer<WatchEvent<?>> consumer) throws IOException {
        WatchService service = FileSystems.getDefault().newWatchService();
        path.register(service, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
        AtomicBoolean stop = new AtomicBoolean(false);
        new Thread(() -> {
            try {
                WatchKey key;
                while ((key = service.take()) != null) {
                    for (WatchEvent<?> event : key.pollEvents()) {
                        consumer.accept(event);
                    }
                    key.reset();
                    if (!stop.get()) continue;
                    break;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }).start();
        this.watchService.put(path, stop);
    }

    private Consumer<WatchEvent<?>> createWatchServiceConsumer(Path path) {
        return event -> {
            try {
                Path relTarg = this.directoryPath.resolve((Path)event.context());
                File relFile = relTarg.toFile();
                WatchEvent.Kind type = event.kind();
                String top2sub = ContextUtil.getContext(this.directoryPath.relativize(path).toString(), true, false);
                String context = ContextUtil.joinContexts(true, false, top2sub, this.adapter.getName(relFile));
                File file = new File(ContextUtil.joinContexts(true, false, this.directoryPath.toString(), top2sub, relFile.getName()));
                Path target = file.toPath();
                if (!file.isDirectory()) {
                    if (type == StandardWatchEventKinds.ENTRY_CREATE) {
                        this.preloadedFiles.put(context, new FileEntry(file, this.adapter, ByteLoadingOption.WATCHLOAD, true));
                    } else if (type == StandardWatchEventKinds.ENTRY_DELETE) {
                        this.preloadedFiles.remove(context);
                    } else if (type == StandardWatchEventKinds.ENTRY_MODIFY) {
                        Objects.requireNonNull(this.preloadedFiles.get(context)).reloadBytes();
                    }
                } else if (this.isWalkthrough) {
                    if (type == StandardWatchEventKinds.ENTRY_CREATE) {
                        try {
                            this.createWatchService(target, this.createWatchServiceConsumer(target));
                        }
                        catch (IOException iOException) {}
                    } else if (type == StandardWatchEventKinds.ENTRY_DELETE) {
                        Objects.requireNonNull(this.watchService.get(relTarg)).set(true);
                        this.watchService.remove(relTarg);
                    }
                }
                this.preloadedFiles.get(context).reloadBytes();
            }
            catch (ClassCastException | NullPointerException runtimeException) {
                // empty catch block
            }
        };
    }

    public final File getDirectory() {
        return this.directory;
    }

    public Map<String, FileEntry> getPreloadedFiles() {
        return Collections.unmodifiableMap(this.preloadedFiles);
    }

    public final File getFile(String path) {
        String relative = ContextUtil.getContext(path, true, false);
        if (this.loadingOption != ByteLoadingOption.LIVELOAD) {
            return this.preloadedFiles.get(relative).getFile();
        }
        String dabs = this.directory.getAbsolutePath();
        File parentFile = new File(dabs + relative).getParentFile();
        String pabs = parentFile.getAbsolutePath();
        if (!(pabs.equals(dabs) || this.isWalkthrough && pabs.startsWith(dabs))) {
            return null;
        }
        File targetFile = Paths.get(dabs, relative).toFile();
        String fileName = targetFile.getParentFile() == null ? targetFile.getPath() : targetFile.getName();
        for (File file : Objects.requireNonNullElse(parentFile.listFiles(), new File[0])) {
            if (!file.isDirectory() && this.adapter.getName(file).equals(fileName)) {
                return file;
            }
            if (!file.isDirectory() || !file.getName().equals(fileName)) continue;
            return file;
        }
        return null;
    }

    public final byte[] getBytes(String path) {
        String rel = ContextUtil.getContext(path, true, false);
        if (this.loadingOption != ByteLoadingOption.LIVELOAD) {
            return this.preloadedFiles.get(rel).getBytes();
        }
        try {
            File file = Objects.requireNonNull(this.getFile(path));
            return !file.isDirectory() ? this.adapter.getBytes(file, Files.readAllBytes(file.toPath())) : null;
        }
        catch (IOException | NullPointerException ignored) {
            return null;
        }
    }

    public final ByteLoadingOption getLoadingOption() {
        return this.loadingOption;
    }

    public final boolean isWalkthrough() {
        return this.isWalkthrough;
    }

    public String toString() {
        return "DirectoryEntry{directory=" + this.directory + ", adapter=" + this.adapter + ", loadingOption=" + this.loadingOption + ", isWalkthrough=" + this.isWalkthrough + ", preloadedFiles=" + this.preloadedFiles + "}";
    }
}

