/*
 * Decompiled with CFR 0.152.
 */
package com.kttdevelopment.simplehttpserver.handler;

import com.kttdevelopment.simplehttpserver.handler.ConnectionThrottler;
import com.sun.net.httpserver.HttpExchange;
import java.net.InetAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class ExchangeThrottler
extends ConnectionThrottler {
    private final Map<InetAddress, AtomicInteger> connections = new ConcurrentHashMap<InetAddress, AtomicInteger>();

    @Override
    final boolean addConnection(HttpExchange exchange) {
        InetAddress address = exchange.getRemoteAddress().getAddress();
        int maxConn = this.getMaxConnections(exchange);
        if (!this.connections.containsKey(address)) {
            this.connections.put(address, new AtomicInteger(0));
        }
        AtomicInteger conn = this.connections.get(address);
        if (maxConn < 0) {
            conn.incrementAndGet();
            return true;
        }
        AtomicBoolean added = new AtomicBoolean(false);
        conn.updateAndGet(operand -> {
            if (operand < maxConn) {
                added.set(true);
            }
            return operand < maxConn ? operand + 1 : operand;
        });
        return added.get();
    }

    @Override
    final void deleteConnection(HttpExchange exchange) {
        InetAddress address = exchange.getRemoteAddress().getAddress();
        if (this.connections.containsKey(address)) {
            this.connections.get(address).decrementAndGet();
        }
    }

    @Override
    public int getMaxConnections(HttpExchange exchange) {
        return -1;
    }

    public String toString() {
        return "Exchange Throttler{connections=" + this.connections.toString() + "}";
    }
}

