/*
 * Decompiled with CFR 0.152.
 */
package com.kttdevelopment.simplehttpserver.handler;

import com.kttdevelopment.simplehttpserver.ContextUtil;
import com.kttdevelopment.simplehttpserver.SimpleHttpExchange;
import com.kttdevelopment.simplehttpserver.SimpleHttpHandler;
import com.kttdevelopment.simplehttpserver.handler.ByteLoadingOption;
import com.kttdevelopment.simplehttpserver.handler.DirectoryEntry;
import com.kttdevelopment.simplehttpserver.handler.FileEntry;
import com.kttdevelopment.simplehttpserver.handler.FileHandlerAdapter;
import com.sun.net.httpserver.HttpExchange;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class FileHandler
implements SimpleHttpHandler {
    private final FileHandlerAdapter adapter;
    private final Map<String, FileEntry> files = new ConcurrentHashMap<String, FileEntry>();
    private final Map<String, DirectoryEntry> directories = new ConcurrentHashMap<String, DirectoryEntry>();

    public FileHandler() {
        this.adapter = new FileHandlerAdapter(){

            @Override
            public byte[] getBytes(File file, byte[] bytes) {
                return bytes;
            }

            @Override
            public String getName(File file) {
                return FileHandler.this.getName(file);
            }
        };
    }

    public FileHandler(FileHandlerAdapter adapter) {
        this.adapter = adapter;
    }

    public final void addFile(File file) {
        this.addFile("", file, this.adapter.getName(file), ByteLoadingOption.LIVELOAD);
    }

    public final void addFile(File file, ByteLoadingOption loadingOption) {
        this.addFile("", file, this.adapter.getName(file), loadingOption);
    }

    public final void addFile(File file, String fileName) {
        this.addFile("", file, fileName, ByteLoadingOption.LIVELOAD);
    }

    public final void addFile(File file, String fileName, ByteLoadingOption loadingOption) {
        this.addFile("", file, fileName, loadingOption);
    }

    public final void addFile(String context, File file) {
        this.addFile(context, file, this.adapter.getName(file), ByteLoadingOption.LIVELOAD);
    }

    public final void addFile(String context, File file, ByteLoadingOption loadingOption) {
        this.addFile(context, file, this.adapter.getName(file), loadingOption);
    }

    public final void addFile(String context, File file, String fileName) {
        this.addFile(context, file, fileName, ByteLoadingOption.LIVELOAD);
    }

    public final void addFile(String context, File file, String fileName, ByteLoadingOption loadingOption) {
        try {
            this.files.put(ContextUtil.joinContexts(true, false, context, fileName), new FileEntry(file, this.adapter, loadingOption));
        }
        catch (UncheckedIOException uncheckedIOException) {
            // empty catch block
        }
    }

    public final void addFiles(File[] files) {
        this.addFiles("", files, ByteLoadingOption.LIVELOAD);
    }

    public final void addFiles(File[] files, ByteLoadingOption loadingOption) {
        this.addFiles("", files, loadingOption);
    }

    public final void addFiles(String context, File[] files) {
        this.addFiles(context, files, ByteLoadingOption.LIVELOAD);
    }

    public final void addFiles(String context, File[] files, ByteLoadingOption loadingOption) {
        for (File file : files) {
            this.addFile(context, file, loadingOption);
        }
    }

    public final void addDirectory(File directory) {
        this.addDirectory("", directory, this.getName(directory), ByteLoadingOption.LIVELOAD, false);
    }

    public final void addDirectory(File directory, boolean walk) {
        this.addDirectory("", directory, this.getName(directory), ByteLoadingOption.LIVELOAD, walk);
    }

    public final void addDirectory(File directory, ByteLoadingOption loadingOption) {
        this.addDirectory("", directory, this.getName(directory), loadingOption, false);
    }

    public final void addDirectory(File directory, ByteLoadingOption loadingOption, boolean walk) {
        this.addDirectory("", directory, this.getName(directory), loadingOption, walk);
    }

    public final void addDirectory(File directory, String directoryName) {
        this.addDirectory("", directory, directoryName, ByteLoadingOption.LIVELOAD, false);
    }

    public final void addDirectory(File directory, String directoryName, boolean walk) {
        this.addDirectory("", directory, directoryName, ByteLoadingOption.LIVELOAD, walk);
    }

    public final void addDirectory(File directory, String directoryName, ByteLoadingOption loadingOption) {
        this.addDirectory("", directory, directoryName, loadingOption, false);
    }

    public final void addDirectory(File directory, String directoryName, ByteLoadingOption loadingOption, boolean walk) {
        this.addDirectory("", directory, directoryName, loadingOption, walk);
    }

    public final void addDirectory(String context, File directory) {
        this.addDirectory(context, directory, this.getName(directory), ByteLoadingOption.LIVELOAD, false);
    }

    public final void addDirectory(String context, File directory, boolean walk) {
        this.addDirectory(context, directory, this.getName(directory), ByteLoadingOption.LIVELOAD, walk);
    }

    public final void addDirectory(String context, File directory, ByteLoadingOption loadingOption) {
        this.addDirectory(context, directory, this.getName(directory), loadingOption, false);
    }

    public final void addDirectory(String context, File directory, ByteLoadingOption loadingOption, boolean walk) {
        this.addDirectory(context, directory, this.getName(directory), loadingOption, walk);
    }

    public final void addDirectory(String context, File directory, String directoryName) {
        this.addDirectory(context, directory, directoryName, ByteLoadingOption.LIVELOAD, false);
    }

    public final void addDirectory(String context, File directory, String directoryName, boolean walk) {
        this.addDirectory(context, directory, directoryName, ByteLoadingOption.LIVELOAD, walk);
    }

    public final void addDirectory(String context, File directory, String directoryName, ByteLoadingOption loadingOption) {
        this.addDirectory(context, directory, directoryName, loadingOption, false);
    }

    public final void addDirectory(String context, File directory, String directoryName, ByteLoadingOption loadingOption, boolean walk) {
        try {
            String target = ContextUtil.joinContexts(true, false, context, directoryName);
            this.directories.put(target, new DirectoryEntry(directory, this.adapter, loadingOption, walk));
        }
        catch (UncheckedIOException uncheckedIOException) {
            // empty catch block
        }
    }

    private String getName(File file) {
        return file.getParentFile() == null ? file.getPath() : file.getName();
    }

    @Override
    public final void handle(SimpleHttpExchange exchange) throws IOException {
        String context = URLDecoder.decode(ContextUtil.getContext(exchange.getURI().getPath().substring(exchange.getHttpContext().getPath().length()), true, false), StandardCharsets.UTF_8);
        if (this.files.containsKey(context)) {
            FileEntry entry = this.files.get(context);
            this.handle(exchange, entry.getFile(), entry.getBytes());
        } else {
            String match = "";
            for (String key : this.directories.keySet()) {
                if (!context.startsWith(key) || !key.startsWith(match)) continue;
                match = key;
            }
            if (match.isEmpty()) {
                this.handle(exchange, null, null);
            } else {
                DirectoryEntry entry = this.directories.get(match);
                String rel = context.substring(match.length());
                File file = entry.getFile(rel);
                this.handle(exchange, file, entry.getBytes(rel));
            }
        }
        exchange.close();
    }

    @Override
    public final void handle(HttpExchange exchange) throws IOException {
        SimpleHttpHandler.super.handle(exchange);
    }

    public void handle(SimpleHttpExchange exchange, File source, byte[] bytes) throws IOException {
        exchange.send(bytes, 200);
    }

    public String toString() {
        return "FileHandler{adapter=" + this.adapter.toString() + ", (loaded) files=" + this.files + ", (loaded) directories=" + this.directories + "}";
    }
}

