/*
 * Decompiled with CFR 0.152.
 */
package com.kttdevelopment.simplehttpserver.handler;

import com.kttdevelopment.simplehttpserver.ContextUtil;
import com.kttdevelopment.simplehttpserver.handler.ByteLoadingOption;
import com.kttdevelopment.simplehttpserver.handler.FileEntry;
import com.kttdevelopment.simplehttpserver.handler.FileHandlerAdapter;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

class DirectoryEntry {
    private final File directory;
    private final FileHandlerAdapter adapter;
    private final ByteLoadingOption loadingOption;
    private final boolean isWalkthrough;
    private final Map<String, FileEntry> files;
    private final Path directoryPath;

    DirectoryEntry(File directory, FileHandlerAdapter adapter, ByteLoadingOption loadingOption, boolean isWalkthrough) {
        block5: {
            this.files = new ConcurrentHashMap<String, FileEntry>();
            this.directory = directory;
            this.adapter = adapter;
            this.loadingOption = loadingOption;
            this.isWalkthrough = isWalkthrough;
            this.directoryPath = directory.toPath();
            if (loadingOption == ByteLoadingOption.LIVELOAD) break block5;
            if (!isWalkthrough) {
                File[] listFiles;
                for (File file : listFiles = Objects.requireNonNullElse(directory.listFiles(File::isFile), new File[0])) {
                    this.addFile(file);
                }
            } else {
                try {
                    Files.walkFileTree(this.directoryPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public final FileVisitResult visitFile(Path path, BasicFileAttributes attrs) {
                            DirectoryEntry.this.addDirectoryFile(path.toFile());
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        }
    }

    private void addFile(File file) {
        this.files.put(ContextUtil.getContext(this.adapter.getName(file), true, false), new FileEntry(file, this.adapter, this.loadingOption));
    }

    private void addDirectoryFile(File file) {
        String relative = this.directoryPath.relativize(file.toPath().getParent()).toString();
        this.files.put(ContextUtil.joinContexts(true, false, relative, this.adapter.getName(file)), new FileEntry(file, this.adapter, this.loadingOption));
    }

    public final File getDirectory() {
        return this.directory;
    }

    public final Map<String, FileEntry> getFiles() {
        return Collections.unmodifiableMap(this.files);
    }

    public final File getFile(String path) {
        String relative = ContextUtil.getContext(path, true, false);
        String dabs = this.directory.getAbsolutePath();
        File parentFile = new File(dabs + relative).getParentFile();
        String pabs = parentFile.getAbsolutePath();
        if (!(pabs.equals(dabs) || this.isWalkthrough && pabs.startsWith(dabs))) {
            return null;
        }
        File targetFile = Paths.get(dabs, relative).toFile();
        String fileName = targetFile.getParentFile() == null ? targetFile.getPath() : targetFile.getName();
        for (File file : Objects.requireNonNullElse(parentFile.listFiles(), new File[0])) {
            if (!fileName.equals(file.isDirectory() ? file.getName() : this.adapter.getName(file))) continue;
            return file;
        }
        return null;
    }

    public final FileEntry getFileEntry(String path) {
        String context = ContextUtil.getContext(path, true, false);
        FileEntry entry = this.files.get(context);
        if (entry == null) {
            File file = this.getFile(path);
            return file != null && file.exists() ? (this.loadingOption != ByteLoadingOption.LIVELOAD ? this.files.put(context, new FileEntry(file, this.adapter, this.loadingOption)) : new FileEntry(file, this.adapter, this.loadingOption)) : null;
        }
        if (!entry.getFile().exists()) {
            this.files.remove(context);
            return null;
        }
        return entry;
    }

    public final byte[] getBytes(String path) {
        if (this.loadingOption != ByteLoadingOption.LIVELOAD) {
            FileEntry entry = this.getFileEntry(path);
            return entry != null ? entry.getBytes() : null;
        }
        try {
            File file = Objects.requireNonNull(this.getFile(path));
            return !file.isDirectory() ? this.adapter.getBytes(file, Files.readAllBytes(file.toPath())) : null;
        }
        catch (IOException | NullPointerException ignored) {
            return null;
        }
    }

    public final ByteLoadingOption getLoadingOption() {
        return this.loadingOption;
    }

    public final boolean isWalkthrough() {
        return this.isWalkthrough;
    }

    public String toString() {
        return "DirectoryEntry{directory=" + this.directory + ", adapter=" + this.adapter + ", loadingOption=" + this.loadingOption + ", isWalkthrough=" + this.isWalkthrough + ", files=" + this.files + "}";
    }
}

