/*
 * Decompiled with CFR 0.152.
 */
package com.kttdevelopment.simplehttpserver.handler;

import com.kttdevelopment.simplehttpserver.SimpleHttpExchange;
import com.kttdevelopment.simplehttpserver.SimpleHttpHandler;
import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class SSEHandler
implements SimpleHttpHandler {
    private final List<OutputStream> listeners = new ArrayList<OutputStream>();
    private final AtomicInteger eventId = new AtomicInteger(-1);
    private final LinkedList<EventStreamRecord> queue = new LinkedList();

    @Override
    public final void handle(HttpExchange exchange) throws IOException {
        SimpleHttpHandler.super.handle(exchange);
    }

    @Override
    public final void handle(SimpleHttpExchange exchange) throws IOException {
        exchange.getResponseHeaders().add("Access-Control-Allow-Headers", "Content-Type");
        if (exchange.getRequestHeaders().getFirst("origin") != null) {
            exchange.getResponseHeaders().add("Access-Control-Allow-Origin", exchange.getRequestHeaders().getFirst("origin"));
        }
        exchange.getResponseHeaders().add("Access-Control-Allow-Methods", "GET, HEAD, POST, PUT, DELETE");
        exchange.getResponseHeaders().add("Access-Control-Max-Age", String.valueOf(TimeUnit.HOURS.toSeconds(1L)));
        exchange.getResponseHeaders().add("Cache-Control", "no-cache");
        if (exchange.getRequestMethod().equals("OPTIONS")) {
            exchange.sendResponseHeaders(200, 0L);
            return;
        }
        exchange.getResponseHeaders().put("content-type", Collections.singletonList("text/event-stream"));
        int latest = 0;
        try {
            latest = Integer.parseInt(exchange.getRequestHeaders().getFirst("Last_Event-ID"));
        }
        catch (NullPointerException | NumberFormatException runtimeException) {
            // empty catch block
        }
        exchange.sendResponseHeaders(200, 0L);
        for (int index = latest; index < this.queue.size(); ++index) {
            exchange.getOutputStream().write(this.queue.get(index).toString(this.eventId.get()).getBytes(StandardCharsets.UTF_8));
            exchange.getOutputStream().flush();
        }
        this.listeners.add(exchange.getOutputStream());
    }

    public final synchronized void push(String data) {
        this.push(data, 0, "");
    }

    public final synchronized void push(String data, int retry, String event) {
        this.eventId.addAndGet(1);
        EventStreamRecord record = new EventStreamRecord(retry, event, data);
        this.queue.add(record);
        this.listeners.forEach(stream -> {
            try {
                stream.write(record.toString(this.eventId.get()).getBytes(StandardCharsets.UTF_8));
                stream.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
    }

    public String toString() {
        return "SSEHandler{listeners=" + this.listeners + ", eventId=" + this.eventId + ", queue=" + this.queue + "}";
    }

    private static class EventStreamRecord {
        private final int retry;
        private final String event;
        private final String data;

        public EventStreamRecord(int retry, String event, String data) {
            this.retry = retry;
            this.event = event;
            this.data = data;
        }

        public final String toString(int id) {
            return "id: " + id + "\n" + (String)(this.retry > 0 ? "retry: " + this.retry + "\n" : "") + (String)(!this.event.isBlank() ? "event: " + this.event + "\n" : "") + (String)(!this.data.isBlank() ? "data: " + this.data + "\n" : "") + "\n";
        }
    }
}

