/*
 * Decompiled with CFR 0.152.
 */
package com.kttdevelopment.simplehttpserver.handler;

import com.kttdevelopment.simplehttpserver.SimpleHttpServer;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;

public class TemporaryHandler
implements HttpHandler {
    private SimpleHttpServer server = null;
    private final HttpHandler handler;
    private boolean hasExpiry;
    private long initTime;
    private long maxTime;
    private long expiry;

    public TemporaryHandler(HttpHandler handler) {
        this.handler = handler;
    }

    public TemporaryHandler(SimpleHttpServer server, HttpHandler handler) {
        this.server = server;
        this.handler = handler;
    }

    public TemporaryHandler(HttpHandler handler, long maxTime) {
        this(null, handler, maxTime);
    }

    public TemporaryHandler(SimpleHttpServer server, HttpHandler handler, long maxTime) {
        this.server = server;
        this.handler = handler;
        this.hasExpiry = true;
        this.initTime = System.currentTimeMillis();
        this.maxTime = maxTime;
        this.expiry = this.initTime + maxTime;
    }

    @Override
    public final void handle(HttpExchange exchange) throws IOException {
        if (!this.hasExpiry || System.currentTimeMillis() < this.expiry) {
            this.handler.handle(exchange);
        }
        if (this.server == null) {
            exchange.getHttpContext().getServer().removeContext(exchange.getHttpContext());
        } else {
            this.server.removeContext(exchange.getHttpContext());
        }
        exchange.close();
    }

    public String toString() {
        return "TemporaryHandler{handler=" + this.handler.toString() + (String)(this.hasExpiry ? ", initTime=" + this.initTime + ", maxTime=" + this.maxTime + ", expiry=" + this.expiry : "") + "}";
    }
}

