/*
 * Decompiled with CFR 0.152.
 */
package com.kttdevelopment.simplehttpserver;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class Record {
    private final Map<String, Header> headers;
    private final String name;
    private final String value;

    Record(Map.Entry<String, Map> entry) {
        this.name = Objects.requireNonNull(entry.getKey());
        this.value = Objects.requireNonNull(entry.getValue().get("value").toString());
        HashMap headers = new HashMap();
        Objects.requireNonNull((Map)entry.getValue().get("headers")).forEach((k, v) -> headers.put(k, new Header(Objects.requireNonNull(v.get("header-name")).toString(), Objects.requireNonNull(v.get("header-value")).toString(), (Map)Objects.requireNonNull(v.get("parameters")))));
        this.headers = Collections.unmodifiableMap(headers);
    }

    public final String getName() {
        return this.name;
    }

    public final Header getHeader(String key) {
        return this.headers.get(key);
    }

    public final Map<String, Header> getHeaders() {
        return this.headers;
    }

    public final String getValue() {
        return this.value;
    }

    public String toString() {
        return "Record{name='" + this.name + "', value='" + this.value + "', headers=" + this.headers + "}";
    }

    public static class Header {
        private final String headerName;
        private final String headerValue;
        private final Map<String, String> headerParams;

        Header(String headerName, String headerValue, Map<String, String> headerParams) {
            this.headerName = headerName;
            this.headerValue = headerValue;
            this.headerParams = Collections.unmodifiableMap(headerParams);
        }

        public final String getHeaderName() {
            return this.headerName;
        }

        public final String getHeaderValue() {
            return this.headerValue;
        }

        public final String getParameter(String key) {
            return this.headerParams.get(key);
        }

        public final Map<String, String> getParameters() {
            return this.headerParams;
        }

        public String toString() {
            return "Header{headerName='" + this.headerName + "', headerValue='" + this.headerValue + "', headerParams=" + this.headerParams + "}";
        }
    }
}

