/*
 * Decompiled with CFR 0.152.
 */
package com.kubedb.client.util;

import com.google.gson.JsonParseException;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.kubedb.client.ApiClient;
import com.kubedb.client.ApiException;
import com.kubedb.client.JSON;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.ResponseBody;
import io.kubernetes.client.models.V1Status;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Watch<T>
implements Iterable<Response<T>>,
Iterator<Response<T>>,
Closeable,
AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(Watch.class);
    Type watchType;
    ResponseBody response;
    JSON json;

    public static <T> Watch<T> createWatch(ApiClient client, Call call, Type watchType) throws ApiException {
        if (client.isDebugging()) {
            log.warn("Watch is (for now) incompatible with debugging mode active. Watches will not return data until the watch connection terminates");
            throw new ApiException("Watch is incompatible with debugging mode active.");
        }
        try {
            com.squareup.okhttp.Response response = call.execute();
            if (!response.isSuccessful()) {
                String respBody = null;
                try (ResponseBody body = response.body();){
                    if (body != null) {
                        respBody = response.body().string();
                    }
                }
                catch (IOException e) {
                    throw new ApiException(response.message(), (Throwable)e, response.code(), response.headers().toMultimap());
                }
                throw new ApiException(response.message(), response.code(), response.headers().toMultimap(), respBody);
            }
            return new Watch<T>(client.getJSON(), response.body(), watchType);
        }
        catch (IOException e) {
            throw new ApiException((Throwable)e);
        }
    }

    private Watch(JSON json, ResponseBody body, Type watchType) {
        this.response = body;
        this.watchType = watchType;
        this.json = json;
    }

    @Override
    public Response<T> next() {
        try {
            String line = this.response.source().readUtf8Line();
            if (line == null) {
                throw new RuntimeException("Null response from the server.");
            }
            try {
                return (Response)this.json.deserialize(line, this.watchType);
            }
            catch (JsonParseException ex) {
                Type statusType = new TypeToken<Response<V1Status>>(){}.getType();
                Response status = (Response)this.json.deserialize(line, statusType);
                return new Response(status.type, (V1Status)status.object);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("IO Exception during next method.", e);
        }
    }

    @Override
    public boolean hasNext() {
        try {
            return !this.response.source().exhausted();
        }
        catch (IOException e) {
            throw new RuntimeException("IO Exception during hasNext method.", e);
        }
    }

    @Override
    public Iterator<Response<T>> iterator() {
        return this;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    @Override
    public void close() throws IOException {
        this.response.close();
    }

    public static class Response<T> {
        @SerializedName(value="type")
        public String type;
        @SerializedName(value="object")
        public T object;
        public V1Status status;

        Response(String type, T object) {
            this.type = type;
            this.object = object;
            this.status = null;
        }

        Response(String type, V1Status status) {
            this.type = type;
            this.object = null;
            this.status = status;
        }
    }
}

