/*
 * Decompiled with CFR 0.152.
 */
package com.lib16.java.arrays;

import java.util.Random;

public final class Arrays {
    private Arrays() {
    }

    public static <T> void swap(T[] array, int index1, int index2) {
        T object = array[index1];
        array[index1] = array[index2];
        array[index2] = object;
    }

    public static <T> void reverse(T[] array) {
        Arrays.reverse(array, 0, array.length);
    }

    public static <T> void reverse(T[] array, int start, int stop) {
        int last = stop - 1;
        stop = (stop - start) / 2 + start;
        int i = start;
        int k = last;
        while (i < stop) {
            Arrays.swap(array, i, k);
            ++i;
            --k;
        }
    }

    public static <T> void rotate(T[] array, int distance) {
        Arrays.rotate(array, distance, 0, array.length);
    }

    public static <T> void rotate(T[] array, int distance, int start, int stop) {
        boolean rotateLeft = distance > 0;
        distance = Math.abs(distance) % (stop - start);
        int index = rotateLeft ? start + distance : stop - distance;
        Arrays.reverse(array, start, index);
        Arrays.reverse(array, index, stop);
        Arrays.reverse(array, start, stop);
    }

    public static <T> void shuffle(T[] array, Random random) {
        Arrays.shuffle(array, random, 0, array.length);
    }

    public static <T> void shuffle(T[] array, Random random, int start, int stop) {
        int count = stop - start;
        int i = start;
        while (i < stop) {
            Arrays.swap(array, i, random.nextInt(count) + start);
            ++i;
        }
    }
}

