/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.db.activerecord;

import com.jfinal.kit.StrKit;
import com.jfinal.template.Engine;
import com.jfinal.template.source.ISource;
import com.litongjava.cache.ICache;
import com.litongjava.db.IPlugin;
import com.litongjava.db.activerecord.Config;
import com.litongjava.db.activerecord.DbKit;
import com.litongjava.db.activerecord.IContainerFactory;
import com.litongjava.db.activerecord.IDataSourceProvider;
import com.litongjava.db.activerecord.IDbProFactory;
import com.litongjava.db.activerecord.Model;
import com.litongjava.db.activerecord.NullDataSource;
import com.litongjava.db.activerecord.Table;
import com.litongjava.db.activerecord.TableBuilder;
import com.litongjava.db.activerecord.cache.DefaultEhCache;
import com.litongjava.db.activerecord.dialect.Dialect;
import com.litongjava.db.activerecord.dialect.MysqlDialect;
import com.litongjava.db.activerecord.sql.SqlKit;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;

public class ReplicaActiveRecordPlugin
implements IPlugin {
    protected TableBuilder tableBuilder = new TableBuilder();
    protected List<IDataSourceProvider> dataSourceProviders;
    protected Boolean devMode = null;
    protected List<Config> configs;
    protected volatile boolean isStarted = false;
    protected List<Table> tableList = new ArrayList<Table>();

    public ReplicaActiveRecordPlugin(List<DataSource> datasources) {
        this.configs = new ArrayList<Config>();
        for (int i = 0; i < datasources.size(); ++i) {
            this.configs.add(new Config("replica_" + i, datasources.get(i), 4));
        }
    }

    public ReplicaActiveRecordPlugin(String configName, DataSource dataSource, int transactionLevel) {
        this.configs = new ArrayList<Config>();
        if (StrKit.isBlank((String)configName)) {
            throw new IllegalArgumentException("configName can not be blank");
        }
        if (dataSource == null) {
            throw new IllegalArgumentException("dataSource can not be null");
        }
        this.configs.add(new Config(configName, dataSource, transactionLevel));
    }

    public ReplicaActiveRecordPlugin(DataSource dataSource) {
        this("main", dataSource);
    }

    public ReplicaActiveRecordPlugin(String configName, DataSource dataSource) {
        this(configName, dataSource, 4);
    }

    public ReplicaActiveRecordPlugin(DataSource dataSource, int transactionLevel) {
        this("main", dataSource, transactionLevel);
    }

    public ReplicaActiveRecordPlugin(String configName, IDataSourceProvider dataSourceProvider, int transactionLevel) {
        this.dataSourceProviders = new ArrayList<IDataSourceProvider>();
        if (StrKit.isBlank((String)configName)) {
            throw new IllegalArgumentException("configName can not be blank");
        }
        if (dataSourceProvider == null) {
            throw new IllegalArgumentException("dataSourceProvider can not be null");
        }
        this.dataSourceProviders.add(dataSourceProvider);
        this.configs.add(new Config(configName, null, transactionLevel));
    }

    public ReplicaActiveRecordPlugin(String configName, List<IDataSourceProvider> dataSourceProviders, int transactionLevel) {
        this.dataSourceProviders = new ArrayList<IDataSourceProvider>();
        if (StrKit.isBlank((String)configName)) {
            throw new IllegalArgumentException("configName can not be blank");
        }
        if (dataSourceProviders == null) {
            throw new IllegalArgumentException("dataSourceProviders can not be null");
        }
        for (int i = 0; i < dataSourceProviders.size(); ++i) {
            this.dataSourceProviders.add(dataSourceProviders.get(i));
            this.configs.add(new Config(configName + "_" + i, null, transactionLevel));
        }
    }

    public ReplicaActiveRecordPlugin(IDataSourceProvider dataSourceProvider) {
        this("replica", dataSourceProvider);
    }

    public ReplicaActiveRecordPlugin(String configName, IDataSourceProvider dataSourceProvider) {
        this(configName, dataSourceProvider, 4);
    }

    public ReplicaActiveRecordPlugin(IDataSourceProvider dataSourceProvider, int transactionLevel) {
        this("replica", dataSourceProvider, transactionLevel);
    }

    public ReplicaActiveRecordPlugin(Config config) {
        if (config == null) {
            throw new IllegalArgumentException("Config can not be null");
        }
        this.configs.add(config);
    }

    public ReplicaActiveRecordPlugin addMapping(String tableName, String primaryKey, Class<? extends Model<?>> modelClass) {
        this.tableList.add(new Table(tableName, primaryKey, modelClass));
        return this;
    }

    public ReplicaActiveRecordPlugin addMapping(String tableName, Class<? extends Model<?>> modelClass) {
        this.tableList.add(new Table(tableName, modelClass));
        return this;
    }

    public ReplicaActiveRecordPlugin addSqlTemplate(String sqlTemplate) {
        for (Config config : this.configs) {
            config.sqlKit.addSqlTemplate(sqlTemplate);
        }
        return this;
    }

    public ReplicaActiveRecordPlugin addSqlTemplate(ISource sqlTemplate) {
        for (Config config : this.configs) {
            config.sqlKit.addSqlTemplate(sqlTemplate);
        }
        return this;
    }

    public ReplicaActiveRecordPlugin setBaseSqlTemplatePath(String baseSqlTemplatePath) {
        for (Config config : this.configs) {
            config.sqlKit.setBaseSqlTemplatePath(baseSqlTemplatePath);
        }
        return this;
    }

    public SqlKit getSqlKit(int i) {
        return this.configs.get((int)i).sqlKit;
    }

    public Engine getEngine(int i) {
        return this.getSqlKit(i).getEngine();
    }

    public ReplicaActiveRecordPlugin setTransactionLevel(int transactionLevel) {
        for (Config config : this.configs) {
            config.setTransactionLevel(transactionLevel);
        }
        return this;
    }

    public ReplicaActiveRecordPlugin setCache(ICache cache) {
        if (cache == null) {
            throw new IllegalArgumentException("cache can not be null");
        }
        for (Config config : this.configs) {
            config.cache = cache;
        }
        return this;
    }

    public ReplicaActiveRecordPlugin setShowSql(boolean showSql) {
        for (Config config : this.configs) {
            config.showSql = showSql;
        }
        return this;
    }

    public ReplicaActiveRecordPlugin setDevMode(boolean devMode) {
        this.devMode = devMode;
        for (Config config : this.configs) {
            config.setDevMode(devMode);
        }
        return this;
    }

    public Boolean getDevMode() {
        return this.devMode;
    }

    public ReplicaActiveRecordPlugin setDialect(Dialect dialect) {
        if (dialect == null) {
            throw new IllegalArgumentException("dialect can not be null");
        }
        for (Config config : this.configs) {
            config.dialect = dialect;
            if (config.transactionLevel != 4 || !dialect.isOracle()) continue;
            config.transactionLevel = 2;
        }
        return this;
    }

    public ReplicaActiveRecordPlugin setContainerFactory(IContainerFactory containerFactory) {
        if (containerFactory == null) {
            throw new IllegalArgumentException("containerFactory can not be null");
        }
        for (Config config : this.configs) {
            config.containerFactory = containerFactory;
        }
        return this;
    }

    public ReplicaActiveRecordPlugin setDbProFactory(IDbProFactory dbProFactory) {
        if (dbProFactory == null) {
            throw new IllegalArgumentException("dbProFactory can not be null");
        }
        for (Config config : this.configs) {
            config.dbProFactory = dbProFactory;
        }
        return this;
    }

    public void setPrimaryKey(String tableName, String primaryKey) {
        for (Table table : this.tableList) {
            if (!table.getName().equalsIgnoreCase(tableName.trim())) continue;
            table.setPrimaryKey(primaryKey);
        }
    }

    @Override
    public boolean start() {
        if (this.isStarted) {
            return true;
        }
        for (int i = 0; i < this.configs.size(); ++i) {
            Config config = this.configs.get(i);
            if (this.dataSourceProviders != null) {
                IDataSourceProvider dataSourceProvider = this.dataSourceProviders.get(i);
                if (config.dataSource == null && dataSourceProvider != null) {
                    config.dataSource = dataSourceProvider.getDataSource();
                }
            }
            if (config.dataSource == null) {
                throw new RuntimeException("ActiveRecord start error: ActiveRecordPlugin need DataSource or DataSourceProvider");
            }
            config.sqlKit.parseSqlTemplate();
            this.tableBuilder.build(this.tableList, config);
        }
        DbKit.addReplicaConfigs(this.configs);
        this.isStarted = true;
        return true;
    }

    @Override
    public boolean stop() {
        for (Config config : this.configs) {
            DbKit.removeConfig(config.getName());
        }
        this.isStarted = false;
        return true;
    }

    public static void useAsDataTransfer(Dialect dialect, IContainerFactory containerFactory, ICache cache) {
        if (dialect == null) {
            throw new IllegalArgumentException("dialect can not be null");
        }
        if (containerFactory == null) {
            throw new IllegalArgumentException("containerFactory can not be null");
        }
        if (cache == null) {
            throw new IllegalArgumentException("cache can not be null");
        }
        ReplicaActiveRecordPlugin arp = new ReplicaActiveRecordPlugin(new NullDataSource());
        arp.setDialect(dialect);
        arp.setContainerFactory(containerFactory);
        arp.setCache(cache);
        arp.start();
        DbKit.brokenConfigs = arp.configs;
    }

    public static void useAsDataTransfer(IContainerFactory containerFactory) {
        ReplicaActiveRecordPlugin.useAsDataTransfer(new MysqlDialect(), containerFactory, new DefaultEhCache());
    }

    public static void useAsDataTransfer(Dialect dialect, IContainerFactory containerFactory) {
        ReplicaActiveRecordPlugin.useAsDataTransfer(dialect, containerFactory, new DefaultEhCache());
    }

    public static void useAsDataTransfer(Dialect dialect) {
        ReplicaActiveRecordPlugin.useAsDataTransfer(dialect, IContainerFactory.defaultContainerFactory, new DefaultEhCache());
    }

    public static void useAsDataTransfer() {
        ReplicaActiveRecordPlugin.useAsDataTransfer(new MysqlDialect(), IContainerFactory.defaultContainerFactory, new DefaultEhCache());
    }

    public Config getConfig(int i) {
        return this.configs.get(i);
    }

    public TableBuilder getTableBuilder() {
        return this.tableBuilder;
    }

    public ReplicaActiveRecordPlugin setTableBuilder(TableBuilder tableBuilder) {
        this.tableBuilder = tableBuilder;
        return this;
    }
}

