/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.redis;

import com.litongjava.jfinal.aop.Interceptor;
import com.litongjava.jfinal.aop.Invocation;
import com.litongjava.redis.Redis;
import com.litongjava.redis.RedisDb;
import redis.clients.jedis.Jedis;

public class RedisInterceptor
implements Interceptor {
    protected RedisDb getCache() {
        return Redis.use();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void intercept(Invocation inv) {
        RedisDb cache = this.getCache();
        Jedis jedis = cache.getThreadLocalJedis();
        if (jedis != null) {
            inv.invoke();
            return;
        }
        try {
            jedis = cache.jedisPool.getResource();
            cache.setThreadLocalJedis(jedis);
            inv.invoke();
        }
        finally {
            cache.removeThreadLocalJedis();
            jedis.close();
        }
    }
}

