/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.redis;

import com.litongjava.cache.CacheableModel;
import com.litongjava.jfinal.aop.AopInterceptor;
import com.litongjava.jfinal.aop.AopInvocation;
import com.litongjava.redis.Redis;
import com.litongjava.redis.RedisDb;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import redis.clients.jedis.Jedis;

public class RedisCacheInterceptor
implements AopInterceptor {
    private static ConcurrentHashMap<String, ReentrantLock> lockMap = new ConcurrentHashMap(512);

    protected RedisDb getCache() {
        return Redis.use();
    }

    private ReentrantLock getLock(String key) {
        ReentrantLock lock = lockMap.get(key);
        if (lock != null) {
            return lock;
        }
        lock = new ReentrantLock();
        ReentrantLock previousLock = lockMap.putIfAbsent(key, lock);
        return previousLock == null ? lock : previousLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void intercept(AopInvocation inv) {
        RedisDb cache = this.getCache();
        Jedis jedis = cache.getThreadLocalJedis();
        if (jedis != null) {
            this.putIfNotExists(inv, cache, jedis);
        }
        try {
            jedis = cache.jedisPool.getResource();
            cache.setThreadLocalJedis(jedis);
            this.putIfNotExists(inv, cache, jedis);
        }
        finally {
            cache.removeThreadLocalJedis();
            jedis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putIfNotExists(AopInvocation inv, RedisDb cache, Jedis jedis) {
        Object target = inv.getTarget();
        CacheableModel cacheableModel = CacheableModel.buildCacheModel(inv, target);
        String redisKey = cacheableModel.getName() + "_" + cacheableModel.getKey();
        String cacheData = (String)cache.get(redisKey);
        if (cacheData == null) {
            ReentrantLock lock = this.getLock(redisKey);
            lock.lock();
            try {
                Object returnValue = inv.invoke();
                cacheData = (String)cache.get(redisKey);
                if (cacheData == null) {
                    cache.setex(redisKey, cacheableModel.getTtl(), returnValue);
                    return;
                }
            }
            finally {
                lock.unlock();
            }
        }
        inv.setReturnValue((Object)cacheData);
    }
}

