/*
 * Decompiled with CFR 0.152.
 */
package com.lotaris.api.test;

import com.jayway.jsonassert.JsonAssert;
import com.jayway.jsonassert.JsonAsserter;
import com.lotaris.api.test.client.ApiTestFormUrlEncoded;
import com.lotaris.api.test.client.ApiTestRequest;
import com.lotaris.api.test.client.ApiTestRequestBody;
import com.lotaris.api.test.client.ApiTestResponse;
import com.lotaris.api.test.client.ApiUriBuilder;
import com.lotaris.api.test.client.IApiTestClientConfiguration;
import com.lotaris.api.test.headers.ApiHeader;
import com.lotaris.api.test.headers.ApiHeadersManager;
import com.lotaris.api.test.headers.IApiHeaderConfiguration;
import com.lotaris.api.test.headers.IApiHeaderConfiguratorLocator;
import com.lotaris.api.test.rules.ApiTestClientRule;
import com.lotaris.api.test.rules.ApiTestHeaderConfigurationRule;
import com.lotaris.api.test.rules.ApiTestHeadersManagerRule;
import java.util.ArrayList;
import java.util.List;
import javax.json.JsonStructure;
import org.apache.http.entity.ContentType;
import org.junit.Rule;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public abstract class AbstractApiTest {
    private ApiTestClientRule clientRule;
    private ApiTestHeadersManagerRule headersManagerRule;
    private ApiTestHeaderConfigurationRule headerConfigurationRule;
    private String entryPoint;
    @Rule
    public RuleChain chain;

    public AbstractApiTest() {
        this.build();
    }

    private void build() {
        this.preBuild();
        this.entryPoint = this.getEntryPoint();
        IApiTestClientConfiguration clientConfiguration = this.getClientConfiguration();
        if (clientConfiguration != null && clientConfiguration.isProxyEnabled()) {
            System.setProperty("http.proxyHost", clientConfiguration.getProxyHost());
            System.setProperty("https.proxyHost", clientConfiguration.getProxyHost());
            System.setProperty("http.proxyPort", clientConfiguration.getProxyPort() + "");
            System.setProperty("https.proxyPort", clientConfiguration.getProxyPort() + "");
        }
        this.clientRule = new ApiTestClientRule(this.getClientConfiguration());
        this.headersManagerRule = new ApiTestHeadersManagerRule();
        this.headerConfigurationRule = new ApiTestHeaderConfigurationRule(this.getHeaderConfiguratorLocator(), this.headersManagerRule);
        this.chain = RuleChain.outerRule((TestRule)this.clientRule).around((TestRule)this.headersManagerRule);
        for (TestRule rule : this.rulesAfterClientRules()) {
            this.chain = this.chain.around(rule);
        }
        this.chain = this.chain.around((TestRule)this.headerConfigurationRule);
        for (TestRule rule : this.rulesAfterHeaderConfigurationRule()) {
            this.chain = this.chain.around(rule);
        }
    }

    protected abstract void preBuild();

    protected abstract String getEntryPoint();

    protected abstract IApiTestClientConfiguration getClientConfiguration();

    protected List<TestRule> rulesAfterClientRules() {
        return new ArrayList<TestRule>();
    }

    protected List<TestRule> rulesAfterHeaderConfigurationRule() {
        return new ArrayList<TestRule>();
    }

    protected abstract IApiHeaderConfiguratorLocator getHeaderConfiguratorLocator();

    protected ApiUriBuilder uri(String ... pathElements) {
        return new ApiUriBuilder(this.entryPoint).path(pathElements);
    }

    protected ApiTestResponse getResource(String singlePath) {
        return this.getResource(this.uri(singlePath));
    }

    protected ApiTestResponse getResource(ApiUriBuilder uriBuilder) {
        return this.executeStandardRequest("GET", uriBuilder, (JsonStructure)null);
    }

    protected ApiTestResponse headResource(String singlePath) {
        return this.headResource(this.uri(singlePath));
    }

    protected ApiTestResponse headResource(ApiUriBuilder uriBuilder) {
        return this.executeRequestWithoutBody("HEAD", uriBuilder);
    }

    protected ApiTestResponse postResource(JsonStructure body, String singlePath) {
        return this.postResource(body, this.uri(singlePath));
    }

    protected ApiTestResponse postResource(JsonStructure body, ApiUriBuilder urlBuilder) {
        return this.executeStandardRequest("POST", urlBuilder, body);
    }

    protected ApiTestResponse postResource(ApiTestFormUrlEncoded body, ApiUriBuilder urlBuilder) {
        return this.executeStandardRequest("POST", urlBuilder, body);
    }

    protected ApiTestResponse putResource(JsonStructure body, String singlePath) {
        return this.putResource(body, this.uri(singlePath));
    }

    protected ApiTestResponse putResource(JsonStructure body, ApiUriBuilder uriBuilder) {
        return this.executeStandardRequest("PUT", uriBuilder, body);
    }

    protected ApiTestResponse putResource(ApiTestFormUrlEncoded body, ApiUriBuilder uriBuilder) {
        return this.executeStandardRequest("PUT", uriBuilder, body);
    }

    protected ApiTestResponse patchResource(JsonStructure body, String singlePath) {
        return this.patchResource(body, this.uri(singlePath));
    }

    protected ApiTestResponse patchResource(JsonStructure body, ApiUriBuilder uriBuilder) {
        return this.executeStandardRequest("PATCH", uriBuilder, body);
    }

    protected ApiTestResponse patchResource(ApiTestFormUrlEncoded body, ApiUriBuilder uriBuilder) {
        return this.executeStandardRequest("PATCH", uriBuilder, body);
    }

    protected ApiTestResponse deleteResource(String singlePath) {
        return this.deleteResource(this.uri(singlePath));
    }

    protected ApiTestResponse deleteResource(ApiUriBuilder uriBuilder) {
        return this.executeStandardRequest("DELETE", uriBuilder, (JsonStructure)null);
    }

    protected void setHeaderForAllRequests(String name, String value) {
        this.setHeaderForAllRequests(new ApiHeader(name, value));
    }

    protected void setHeaderForAllRequests(ApiHeader header) {
        this.headersManagerRule.getHeadersManager().configure(ApiHeadersManager.Operation.SET, header, true);
    }

    protected void setHeadersForAllRequests(IApiHeaderConfiguration headerConfiguration) {
        this.headersManagerRule.getHeadersManager().configure(ApiHeadersManager.Operation.SET, headerConfiguration, true);
    }

    protected void setHeaderForNextRequest(String name, String value) {
        this.setHeaderForNextRequest(new ApiHeader(name, value));
    }

    protected void setHeaderForNextRequest(ApiHeader header) {
        this.headersManagerRule.getHeadersManager().configure(ApiHeadersManager.Operation.SET, header, false);
    }

    protected void setHeadersForNextRequest(IApiHeaderConfiguration headerConfiguration) {
        this.headersManagerRule.getHeadersManager().configure(ApiHeadersManager.Operation.SET, headerConfiguration, false);
    }

    protected void replaceHeaderForAllRequests(String name, String value) {
        this.setHeaderForAllRequests(name, value);
    }

    protected void replaceHeaderForAllRequests(ApiHeader header) {
        this.setHeaderForAllRequests(header);
    }

    protected void replaceHeaderForNextRequest(String name, String value) {
        this.setHeaderForNextRequest(name, value);
    }

    protected void replaceHeaderForNextRequest(ApiHeader header) {
        this.setHeaderForNextRequest(header);
    }

    protected void removeHeaderForAllRequests(String name) {
        this.removeHeaderForAllRequests(new ApiHeader(name, null));
    }

    protected void removeHeaderForAllRequests(ApiHeader header) {
        this.headersManagerRule.getHeadersManager().configure(ApiHeadersManager.Operation.REMOVE, header, true);
    }

    protected void removeHeadersForAllRequests(IApiHeaderConfiguration headerConfiguration) {
        this.headersManagerRule.getHeadersManager().configure(ApiHeadersManager.Operation.REMOVE, headerConfiguration, true);
    }

    protected void removeHeaderForNextRequest(String name) {
        this.removeHeaderForNextRequest(new ApiHeader(name, null));
    }

    protected void removeHeaderForNextRequest(ApiHeader header) {
        this.headersManagerRule.getHeadersManager().configure(ApiHeadersManager.Operation.REMOVE, header, false);
    }

    protected void removeHeadersForNextRequest(IApiHeaderConfiguration headerConfiguration) {
        this.headersManagerRule.getHeadersManager().configure(ApiHeadersManager.Operation.REMOVE, headerConfiguration, false);
    }

    protected JsonAsserter withJson(String response) {
        return JsonAssert.with((String)response);
    }

    protected JsonAsserter withJson(ApiTestResponse response) {
        return this.withJson(response.getResponseAsString());
    }

    private ApiTestResponse executeStandardRequest(String method, ApiUriBuilder uriBuilder, JsonStructure json) {
        return this.executeStandardRequest(method, uriBuilder, json != null ? ApiTestRequestBody.from(json) : null);
    }

    private ApiTestResponse executeStandardRequest(String method, ApiUriBuilder uriBuilder, ApiTestFormUrlEncoded data) {
        return this.executeStandardRequest(method, uriBuilder, data != null ? ApiTestRequestBody.from(data) : null);
    }

    private ApiTestResponse executeStandardRequest(String method, ApiUriBuilder uriBuilder, ApiTestRequestBody entity) {
        ApiTestRequest request = new ApiTestRequest(method, uriBuilder, entity);
        request.setHeader("Accept", ContentType.APPLICATION_JSON.getMimeType());
        this.headersManagerRule.getHeadersManager().applyConfiguration(request);
        return this.clientRule.getClient().execute(request);
    }

    private ApiTestResponse executeRequestWithoutBody(String method, ApiUriBuilder uriBuilder) {
        ApiTestRequest request = new ApiTestRequest(method, uriBuilder);
        this.headersManagerRule.getHeadersManager().applyConfiguration(request);
        return this.clientRule.getClient().execute(request);
    }
}

