/*
 * Decompiled with CFR 0.152.
 */
package com.lotaris.api.test.client;

import com.lotaris.api.test.client.ApiTestException;
import com.lotaris.api.test.client.ApiTestRequest;
import com.lotaris.api.test.client.ApiTestResponse;
import com.lotaris.api.test.client.IApiTestClientConfiguration;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public class ApiTestClient {
    private CloseableHttpClient client;

    public ApiTestClient(final IApiTestClientConfiguration clientConfiguration) {
        if (clientConfiguration.isProxyEnabled()) {
            HttpHost proxy = new HttpHost(clientConfiguration.getProxyHost(), clientConfiguration.getProxyPort());
            DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxy){

                public HttpRoute determineRoute(HttpHost host, HttpRequest request, HttpContext context) throws HttpException {
                    String hostname = host.getHostName();
                    for (String hostToCheck : clientConfiguration.getProxyExceptions()) {
                        if (!hostname.equals(hostToCheck)) continue;
                        return new HttpRoute(host);
                    }
                    return super.determineRoute(host, request, context);
                }
            };
            this.client = HttpClients.custom().setRoutePlanner((HttpRoutePlanner)routePlanner).build();
        } else {
            this.client = HttpClients.createDefault();
        }
    }

    public void close() {
        try {
            this.client.close();
        }
        catch (IOException ex) {
            throw new ApiTestException("Could not close the HTTP client", ex);
        }
    }

    public ApiTestResponse execute(ApiTestRequest request) {
        try {
            CloseableHttpResponse response = this.client.execute(request.getRequestObject());
            return this.buildResponse(response).enrichFromRequest(request);
        }
        catch (IOException ioe) {
            throw new ApiTestException("Could not complete request " + request, ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ApiTestResponse buildResponse(CloseableHttpResponse response) throws IOException {
        ApiTestResponse responseWrapper;
        try {
            responseWrapper = new ApiTestResponse((HttpResponse)response);
            EntityUtils.consume((HttpEntity)response.getEntity());
        }
        finally {
            response.close();
        }
        return responseWrapper;
    }
}

