/*
 * Decompiled with CFR 0.152.
 */
package com.lotaris.api.test.client;

import com.lotaris.api.test.client.ApiTestException;
import com.lotaris.api.test.client.ApiTestRequestBody;
import com.lotaris.api.test.client.ApiUriBuilder;
import java.net.URI;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;

public class ApiTestRequest {
    public static final String GET = "GET";
    public static final String HEAD = "HEAD";
    public static final String POST = "POST";
    public static final String PUT = "PUT";
    public static final String PATCH = "PATCH";
    public static final String DELETE = "DELETE";
    private HttpUriRequest request;

    public ApiTestRequest(String method, ApiUriBuilder uriBuilder) {
        this(method, uriBuilder, null);
    }

    public ApiTestRequest(String method, ApiUriBuilder uriBuilder, ApiTestRequestBody body) {
        this.request = ApiTestRequest.buildRequestObject(method, uriBuilder.build());
        if (body != null) {
            this.setBody(body.toEntity());
        }
    }

    public URI getUri() {
        return this.request.getURI();
    }

    public String getMethod() {
        return this.request.getMethod();
    }

    public ApiTestRequest addHeader(String name, Object value) {
        this.request.addHeader(name, value.toString());
        return this;
    }

    public ApiTestRequest setHeader(String name, Object value) {
        this.request.removeHeaders(name);
        this.request.setHeader(name, value.toString());
        return this;
    }

    public ApiTestRequest removeHeader(String name) {
        this.request.removeHeaders(name);
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.request.getMethod() + " " + this.request.getURI().toString());
        Header[] headers = this.request.getAllHeaders();
        if (headers.length >= 1) {
            builder.append(", headers:");
            for (Header header : headers) {
                builder.append(" ");
                builder.append(header.getName()).append("=\"").append(header.getValue()).append("\"");
            }
        }
        return builder.toString();
    }

    protected HttpUriRequest getRequestObject() {
        return this.request;
    }

    private void setBody(HttpEntity entity) {
        if (!(this.request instanceof HttpEntityEnclosingRequest)) {
            throw new ApiTestException(this.request.getMethod() + " requests cannot have a body");
        }
        ((HttpEntityEnclosingRequest)this.request).setEntity(entity);
    }

    private static HttpUriRequest buildRequestObject(String method, URI uri) {
        switch (method) {
            case "GET": {
                return new HttpGet(uri);
            }
            case "HEAD": {
                return new HttpHead(uri);
            }
            case "POST": {
                return new HttpPost(uri);
            }
            case "PUT": {
                return new HttpPut(uri);
            }
            case "PATCH": {
                return new HttpPatch(uri);
            }
            case "DELETE": {
                return new HttpDelete(uri);
            }
        }
        throw new ApiTestException("Unsupported HTTP method " + method);
    }
}

