/*
 * Decompiled with CFR 0.152.
 */
package com.lotaris.api.test.client;

import com.lotaris.api.test.client.ApiTestFormUrlEncoded;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.json.Json;
import javax.json.JsonStructure;
import javax.json.JsonWriter;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;

public class ApiTestRequestBody {
    public static final String APPLICATION_JSON = ContentType.APPLICATION_JSON.getMimeType();
    private final HttpEntity body;

    public static ApiTestRequestBody fromJson(String json) {
        return new ApiTestRequestBody(json.getBytes(), APPLICATION_JSON);
    }

    public static ApiTestRequestBody from(JsonStructure json) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (JsonWriter writer = Json.createWriter((OutputStream)baos);){
            writer.write(json);
        }
        return new ApiTestRequestBody(baos.toByteArray(), APPLICATION_JSON);
    }

    public static ApiTestRequestBody from(ApiTestFormUrlEncoded data) {
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(data.getPairs(), StandardCharsets.UTF_8);
        return new ApiTestRequestBody((HttpEntity)entity);
    }

    public ApiTestRequestBody(byte[] data, String mediaType) {
        this(data, mediaType, StandardCharsets.UTF_8);
    }

    public ApiTestRequestBody(byte[] data, String mediaType, Charset charset) {
        this((HttpEntity)new InputStreamEntity((InputStream)new ByteArrayInputStream(data), ContentType.create((String)mediaType, (Charset)charset)));
    }

    protected ApiTestRequestBody(HttpEntity entity) {
        this.body = entity;
    }

    protected HttpEntity toEntity() {
        return this.body;
    }
}

