/*
 * Decompiled with CFR 0.152.
 */
package com.lotaris.api.test.client;

import com.lotaris.api.test.client.ApiTestRequest;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;

public class ApiTestResponse {
    private HttpResponse response;
    private String responseBody;
    private URI requestUri;

    protected ApiTestResponse(HttpResponse response) throws IOException {
        this.response = response;
        this.responseBody = ApiTestResponse.readResponseBody(response);
    }

    public int getStatus() {
        return this.response.getStatusLine().getStatusCode();
    }

    public String getHeaderString(String headerName) {
        return this.response.getFirstHeader(headerName).getValue();
    }

    public String getResponseAsString() {
        return this.responseBody != null ? this.responseBody : "";
    }

    public JsonObject getResponseAsJsonObject() {
        return Json.createReader((Reader)new StringReader(this.getResponseAsString())).readObject();
    }

    public URI getRequestUri() {
        return this.requestUri;
    }

    public ApiTestResponse enrichFromRequest(ApiTestRequest request) {
        this.requestUri = request.getUri();
        return this;
    }

    public JsonArray getResponseAsJsonArray() {
        return Json.createReader((Reader)new StringReader(this.getResponseAsString())).readArray();
    }

    private static String readResponseBody(HttpResponse response) throws IOException {
        return response.getEntity() != null ? EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8) : null;
    }
}

