/*
 * Decompiled with CFR 0.152.
 */
package com.lotaris.api.test.client;

import com.lotaris.api.test.client.ApiTestException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.client.utils.URIBuilder;

public class ApiUriBuilder {
    private String baseUri;
    private Map<String, List<Object>> queryParams;
    private List<String> pathElements;

    public ApiUriBuilder(String baseUri) {
        this.baseUri = baseUri.replaceFirst("\\/$", "");
        this.queryParams = new HashMap<String, List<Object>>();
        this.pathElements = new ArrayList<String>();
    }

    public ApiUriBuilder path(String ... elements) {
        for (String element : elements) {
            this.pathElements.add(element.replaceFirst("^\\/", "").replaceFirst("\\/$", ""));
        }
        return this;
    }

    public ApiUriBuilder queryParam(String name, Object value) {
        this.getQueryParamList(name).add(value);
        return this;
    }

    public ApiUriBuilder queryParam(String name, Object ... values) {
        for (Object value : values) {
            this.queryParam(name, value);
        }
        return this;
    }

    public URI build() {
        try {
            return this.buildUri();
        }
        catch (URISyntaxException use) {
            throw new ApiTestException("URI entry point, path elements or query parameters are invalid", use);
        }
    }

    private List<Object> getQueryParamList(String name) {
        if (!this.queryParams.containsKey(name)) {
            this.queryParams.put(name, new ArrayList());
        }
        return this.queryParams.get(name);
    }

    private URI buildUri() throws URISyntaxException {
        StringBuilder builder = new StringBuilder(this.baseUri);
        for (String element : this.pathElements) {
            builder.append("/").append(element);
        }
        URIBuilder uriBuilder = new URIBuilder(builder.toString());
        for (Map.Entry<String, List<Object>> queryParam : this.queryParams.entrySet()) {
            for (Object value : queryParam.getValue()) {
                uriBuilder.addParameter(queryParam.getKey(), value.toString());
            }
        }
        return uriBuilder.build();
    }
}

