/*
 * Decompiled with CFR 0.152.
 */
package com.lotaris.api.test.headers;

import com.lotaris.api.test.client.ApiTestRequest;
import com.lotaris.api.test.headers.ApiHeader;
import com.lotaris.api.test.headers.IApiHeaderConfiguration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ApiHeadersManager {
    private final List<HeaderOperation> permanentHeaders = new ArrayList<HeaderOperation>();
    private final List<HeaderOperation> nextRequestHeaders = new ArrayList<HeaderOperation>();

    public ApiHeadersManager configure(Operation op, ApiHeader header, boolean forAllRequests) {
        if (op == null) {
            throw new IllegalArgumentException("Operation cannot be null");
        }
        if (header == null) {
            throw new IllegalArgumentException("Header cannot be null");
        }
        HeaderOperation operation = new HeaderOperation(header, op);
        this.cleanHeaderOperations(operation, forAllRequests);
        (forAllRequests ? this.permanentHeaders : this.nextRequestHeaders).add(operation);
        if (Operation.ADD.equals(op) && forAllRequests) {
            this.nextRequestHeaders.add(operation);
        }
        return this;
    }

    public ApiHeadersManager configure(Operation op, IApiHeaderConfiguration headerConfiguration, boolean forAllRequests) {
        if (headerConfiguration == null) {
            throw new IllegalArgumentException("Header configuration cannot be null");
        }
        for (ApiHeader header : headerConfiguration.getHeaders()) {
            this.configure(op, header, forAllRequests);
        }
        return this;
    }

    public ApiHeadersManager applyConfiguration(ApiTestRequest request) {
        for (HeaderOperation op : this.permanentHeaders) {
            op.apply(request);
        }
        for (HeaderOperation op : this.nextRequestHeaders) {
            op.apply(request);
        }
        this.nextRequestHeaders.clear();
        return this;
    }

    private void cleanHeaderOperations(HeaderOperation op, boolean forAllRequests) {
        if (!Operation.ADD.equals(op.getOperation())) {
            ApiHeadersManager.clearHeaderOperations(this.nextRequestHeaders, op.getHeaderName());
            if (forAllRequests) {
                ApiHeadersManager.clearHeaderOperations(this.permanentHeaders, op.getHeaderName());
            }
        }
    }

    private static void clearHeaderOperations(List<HeaderOperation> operations, String headerName) {
        Iterator<HeaderOperation> iterator = operations.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().getHeaderName().equals(headerName)) continue;
            iterator.remove();
        }
    }

    private static class HeaderOperation {
        private ApiHeader header;
        private Operation operation;

        public HeaderOperation(ApiHeader header, Operation operation) {
            this.header = header;
            this.operation = operation;
        }

        public Operation getOperation() {
            return this.operation;
        }

        public String getHeaderName() {
            return this.header.getName();
        }

        public void apply(ApiTestRequest request) {
            this.operation.apply(request, this.header);
        }
    }

    private static interface ApiRequestHeaderModification {
        public void apply(ApiTestRequest var1, ApiHeader var2);
    }

    public static enum Operation implements ApiRequestHeaderModification
    {
        ADD{

            @Override
            public void apply(ApiTestRequest request, ApiHeader header) {
                request.addHeader(header.getName(), header.computeValue(request));
            }
        }
        ,
        SET{

            @Override
            public void apply(ApiTestRequest request, ApiHeader header) {
                request.setHeader(header.getName(), header.computeValue(request));
            }
        }
        ,
        REMOVE{

            @Override
            public void apply(ApiTestRequest request, ApiHeader header) {
                request.removeHeader(header.getName());
            }
        };

    }
}

