/*
 * Decompiled with CFR 0.152.
 */
package com.lotaris.api.test.matchers;

import com.jayway.jsonpath.Filter;
import com.jayway.jsonpath.InvalidPathException;
import com.jayway.jsonpath.JsonPath;
import com.lotaris.api.test.client.ApiTestResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;

public class ApiErrorResponseMatcher
extends BaseMatcher<ApiTestResponse> {
    private Integer expectedHttpStatusCode;
    private List<ErrorExpectation> expectedErrors = new ArrayList<ErrorExpectation>();
    private boolean isNonNullResponse;
    private Integer actualHttpStatusCode;
    private boolean httpStatusCodeMatches;
    private String contentType;
    private boolean isJsonResponse;
    private boolean hasErrorsProperty;
    private List<Object> invalidErrors;
    private List<Error> actualErrors;
    private List<ErrorExpectation> unmetErrorExpectations;
    private String requestUri;

    public static ApiErrorResponseMatcher isApiErrorResponse(int expectedHttpStatusCode) {
        return new ApiErrorResponseMatcher(expectedHttpStatusCode);
    }

    public ApiErrorResponseMatcher(int expectedHttpStatusCode) {
        this.expectedHttpStatusCode = expectedHttpStatusCode;
    }

    public ApiErrorResponseMatcher withError(int code) {
        return this.withError(code, null, null, (String)null);
    }

    public ApiErrorResponseMatcher withError(int code, String locationType, String location) {
        return this.withError(code, locationType, location, (String)null);
    }

    public ApiErrorResponseMatcher withError(int code, Pattern messagePattern) {
        return this.withError(code, null, null, messagePattern);
    }

    public ApiErrorResponseMatcher withError(int code, String locationType, String location, String message) {
        this.expectedErrors.add(new ErrorExpectation(code, locationType, location, message));
        return this;
    }

    public ApiErrorResponseMatcher withError(int code, String locationType, String location, Pattern messagePattern) {
        this.expectedErrors.add(new ErrorExpectation(code, locationType, location, messagePattern));
        return this;
    }

    public boolean matches(Object item) {
        JSONArray errors;
        this.isNonNullResponse = true;
        this.actualHttpStatusCode = null;
        this.httpStatusCodeMatches = true;
        this.contentType = null;
        this.isJsonResponse = true;
        this.hasErrorsProperty = true;
        this.invalidErrors = new ArrayList<Object>();
        this.actualErrors = new ArrayList<Error>();
        this.unmetErrorExpectations = new ArrayList<ErrorExpectation>();
        ApiTestResponse response = (ApiTestResponse)item;
        if (response == null) {
            this.isNonNullResponse = false;
            return false;
        }
        this.requestUri = response.getRequestUri() != null ? response.getRequestUri().toString() : "<request URI not available>";
        this.actualHttpStatusCode = response.getStatus();
        this.httpStatusCodeMatches = this.expectedHttpStatusCode == null || this.expectedHttpStatusCode.equals(this.actualHttpStatusCode);
        this.contentType = response.getHeaderString("Content-Type");
        if (this.contentType == null || !this.contentType.matches("^application\\/json")) {
            this.isJsonResponse = false;
            return false;
        }
        try {
            errors = (JSONArray)JsonPath.read((String)response.getResponseAsString(), (String)"$.errors", (Filter[])new Filter[0]);
        }
        catch (InvalidPathException | ClassCastException e) {
            this.hasErrorsProperty = false;
            return false;
        }
        this.parseErrors(errors);
        for (ErrorExpectation expectedError : this.expectedErrors) {
            boolean found = false;
            for (Error actualError : this.actualErrors) {
                if (!expectedError.matches(actualError)) continue;
                this.actualErrors.remove(actualError);
                found = true;
                break;
            }
            if (found) continue;
            this.unmetErrorExpectations.add(expectedError);
        }
        return this.httpStatusCodeMatches && this.hasErrorsProperty && this.invalidErrors.isEmpty() && this.unmetErrorExpectations.isEmpty() && this.actualErrors.isEmpty();
    }

    public void describeTo(Description description) {
        description.appendText("JSON API error response");
        if (this.expectedHttpStatusCode != null) {
            description.appendText(" with HTTP status code " + this.expectedHttpStatusCode);
        }
        if (!this.expectedErrors.isEmpty()) {
            description.appendValueList(" with " + this.expectedErrors.size() + " errors: ", ", ", "", this.expectedErrors);
        }
    }

    public void describeMismatch(Object item, Description description) {
        if (!this.isNonNullResponse) {
            description.appendText("response is null");
            return;
        }
        description.appendText("response for URI ").appendText(this.requestUri).appendText(" doesn't match");
        if (!this.httpStatusCodeMatches) {
            description.appendText(", has HTTP status code " + this.actualHttpStatusCode);
        }
        if (!this.isJsonResponse) {
            description.appendText(", is not JSON (content type is " + this.contentType + ")");
        }
        if (!this.hasErrorsProperty) {
            description.appendText(", has no \"errors\" array property");
        }
        if (!this.invalidErrors.isEmpty()) {
            description.appendValueList(", has " + this.invalidErrors.size() + " invalid errors (", ", ", ")", this.invalidErrors);
        }
        if (!this.unmetErrorExpectations.isEmpty()) {
            description.appendValueList(", is missing " + this.unmetErrorExpectations.size() + " expected errors (", ", ", ")", this.unmetErrorExpectations);
        }
        if (!this.actualErrors.isEmpty()) {
            description.appendValueList(", has " + this.actualErrors.size() + " additional unexpected errors (", ", ", ")", this.actualErrors);
        }
        ApiTestResponse response = (ApiTestResponse)item;
        description.appendText("\n          body: ").appendText(response.getResponseAsString());
    }

    private void parseErrors(JSONArray errors) {
        for (Object object : errors) {
            if (!(object instanceof JSONObject)) {
                this.invalidErrors.add(object);
                continue;
            }
            JSONObject error = (JSONObject)object;
            if (!(error.get((Object)"code") instanceof Integer)) {
                this.invalidErrors.add(object);
                continue;
            }
            if (error.containsKey((Object)"locationType") && !(error.get((Object)"locationType") instanceof String)) {
                this.invalidErrors.add(object);
                continue;
            }
            if (error.containsKey((Object)"location") && !(error.get((Object)"location") instanceof String)) {
                this.invalidErrors.add(object);
                continue;
            }
            if (!(error.get((Object)"message") instanceof String)) {
                this.invalidErrors.add(object);
                continue;
            }
            this.actualErrors.add(new Error((Integer)error.get((Object)"code"), (String)error.get((Object)"locationType"), (String)error.get((Object)"location"), (String)error.get((Object)"message")));
        }
    }

    private static class ErrorExpectation {
        private int code;
        private String locationType;
        private String location;
        private String message;
        private Pattern messagePattern;

        public ErrorExpectation(int code, String locationType, String location, String message) {
            this.code = code;
            this.locationType = locationType;
            this.location = location;
            this.message = message;
        }

        public ErrorExpectation(int code, String locationType, String location, Pattern messagePattern) {
            this.code = code;
            this.locationType = locationType;
            this.location = location;
            this.messagePattern = messagePattern;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("code=").append(this.code);
            if (this.locationType != null) {
                builder.append(", locationType=").append(this.locationType);
            } else {
                builder.append(", no locationType");
            }
            if (this.location != null) {
                builder.append(", location=").append(this.location);
            } else {
                builder.append(", no location");
            }
            if (this.message != null) {
                builder.append(", message=").append(this.message);
            } else if (this.messagePattern != null) {
                builder.append(", message~=").append(this.messagePattern.toString());
            } else {
                builder.append(", non-blank message");
            }
            return builder.toString();
        }

        public boolean matches(Error error) {
            if (this.code != error.getCode()) {
                return false;
            }
            if (this.locationType != null ? !this.locationType.equals(error.getLocationType()) : error.getLocationType() != null) {
                return false;
            }
            if (this.location != null ? !this.location.equals(error.getLocation()) : error.getLocation() != null) {
                return false;
            }
            if (this.message != null) {
                return this.message.equals(error.getMessage());
            }
            if (this.messagePattern != null) {
                return error.getMessage() != null && this.messagePattern.matcher(error.getMessage()).matches();
            }
            return error.getMessage() != null && !error.getMessage().isEmpty();
        }
    }

    private static class Error {
        private int code;
        private String locationType;
        private String location;
        private String message;

        public Error(int code, String locationType, String location, String message) {
            this.code = code;
            this.locationType = locationType;
            this.location = location;
            this.message = message;
        }

        public int getCode() {
            return this.code;
        }

        public String getLocationType() {
            return this.locationType;
        }

        public String getLocation() {
            return this.location;
        }

        public String getMessage() {
            return this.message;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("code=").append(this.code);
            if (this.locationType != null) {
                builder.append(", locationType=").append(this.locationType);
            }
            if (this.location != null) {
                builder.append(", location=").append(this.location);
            }
            builder.append(", message=").append(this.message);
            return builder.toString();
        }
    }
}

