/*
 * Decompiled with CFR 0.152.
 */
package com.lotaris.api.test.matchers;

import com.lotaris.api.test.client.ApiTestResponse;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;

public class ApiResponseMatcher
extends BaseMatcher<ApiTestResponse> {
    private int expectedHttpStatusCode;
    private String expectedBody;
    private String actualBody;
    private boolean statusCodeMatches;
    private boolean bodyMatches;

    public ApiResponseMatcher withStatusCode(int expectedHttpStatusCode) {
        this.expectedHttpStatusCode = expectedHttpStatusCode;
        return this;
    }

    public ApiResponseMatcher withBody(String body) {
        this.expectedBody = body;
        return this;
    }

    public ApiResponseMatcher withEmptyBody() {
        this.expectedBody = "";
        return this;
    }

    public ApiResponseMatcher withOnlyRootElement() {
        this.expectedBody = "{}";
        return this;
    }

    public ApiResponseMatcher ignoreBody() {
        this.expectedBody = null;
        return this;
    }

    public boolean matches(Object res) {
        ApiTestResponse response = (ApiTestResponse)res;
        if (response == null) {
            return false;
        }
        this.bodyMatches = true;
        if (this.expectedBody != null) {
            this.actualBody = response.getResponseAsString();
            this.bodyMatches = this.actualBody.equals(this.expectedBody);
        }
        this.statusCodeMatches = response.getStatus() == this.expectedHttpStatusCode;
        return this.bodyMatches && this.statusCodeMatches;
    }

    public void describeTo(Description description) {
        description.appendText("response with HTTP status code " + this.expectedHttpStatusCode);
        if (this.expectedBody != null) {
            description.appendText("".equals(this.expectedBody) ? " and no body" : " and body " + this.expectedBody);
        }
    }

    public void describeMismatch(Object item, Description description) {
        if (item == null) {
            description.appendText("response is null");
            return;
        }
        ApiTestResponse response = (ApiTestResponse)item;
        description.appendText("response doesn't match");
        if (!this.statusCodeMatches) {
            description.appendText(", status code is " + response.getStatus());
        }
        if (!this.bodyMatches) {
            description.appendText("\n          body: " + this.actualBody);
        }
    }
}

