/*
 * Decompiled with CFR 0.152.
 */
package com.lotaris.api.test.matchers;

import com.jayway.jsonpath.Filter;
import com.jayway.jsonpath.JsonPath;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;

public class JsonErrorMatcher
extends BaseMatcher<String> {
    private List<Map.Entry<String, Integer>> expectedErrors;
    private List<Map.Entry<String, Integer>> expectedErrorsLog;
    private boolean sizeMatches;
    private boolean errorMatches = true;
    private boolean errorMessageMatches = true;
    private int errorsReceived = 0;
    private String missingErrorMessageLocation;
    private int missingErrorMessageCode;

    public JsonErrorMatcher withExpectedErrors(List<Map.Entry<String, Integer>> expectedErrors) {
        this.expectedErrors = new ArrayList<Map.Entry<String, Integer>>(expectedErrors);
        this.expectedErrorsLog = new ArrayList<Map.Entry<String, Integer>>(expectedErrors);
        return this;
    }

    public boolean matches(Object item) {
        JSONArray errors;
        String response = (String)item;
        if (response != null && (errors = (JSONArray)JsonPath.read((String)response, (String)"$.errors", (Filter[])new Filter[0])) != null) {
            if (this.expectedErrors != null) {
                this.sizeMatches = errors.size() == this.expectedErrors.size();
                this.errorsReceived = errors.size();
            }
            if (this.expectedErrors != null) {
                Iterator error = errors.iterator();
                while (error.hasNext()) {
                    boolean found = false;
                    JSONObject jsonError = (JSONObject)error.next();
                    Iterator<Map.Entry<String, Integer>> expectedError = this.expectedErrors.iterator();
                    while (expectedError.hasNext() && !found) {
                        Map.Entry<String, Integer> e = expectedError.next();
                        if (!e.getKey().equals(jsonError.get((Object)"location")) || !e.getValue().equals(jsonError.get((Object)"code"))) continue;
                        if (jsonError.get((Object)"message") == null) {
                            this.missingErrorMessageLocation = (String)jsonError.get((Object)"location");
                            this.missingErrorMessageCode = (Integer)jsonError.get((Object)"code");
                            this.errorMessageMatches = false;
                            return false;
                        }
                        found = true;
                        expectedError.remove();
                    }
                    if (found) continue;
                    this.errorMatches = false;
                    return false;
                }
                if (!this.expectedErrors.isEmpty()) {
                    this.errorMatches = false;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public void describeMismatch(Object item, Description description) {
        String response = (String)item;
        if (response != null && !response.isEmpty()) {
            if (!this.sizeMatches) {
                description.appendText("The size of the errors received doesn't match. Expected: " + this.expectedErrorsLog.size() + " Received: " + this.errorsReceived + "\n");
            }
            if (!this.errorMessageMatches) {
                description.appendText("Error with location: " + this.missingErrorMessageLocation + " and code: " + this.missingErrorMessageCode + "doesn't have an error message.\n");
            }
            if (!this.errorMatches) {
                description.appendText("At least one error that was expected was not found in the response: \n");
                description.appendText("Location: " + this.expectedErrorsLog.get(0).getKey() + " Code: " + this.expectedErrorsLog.get(0).getValue() + "\n");
            }
        } else {
            description.appendText("The provided response was null or empty.");
        }
    }

    public void describeTo(Description description) {
        description.appendText("Number of errors expected: " + this.expectedErrorsLog.size() + "\n");
        for (Map.Entry<String, Integer> e : this.expectedErrorsLog) {
            description.appendText("Location: " + e.getKey() + " Code: " + e.getValue() + ",\n");
        }
    }
}

