/*
 * Decompiled with CFR 0.152.
 */
package com.lotaris.api.test.matchers;

import com.lotaris.api.test.matchers.ApiErrorResponseMatcher;
import com.lotaris.api.test.matchers.ApiResponseMatcher;
import java.util.Collection;
import java.util.Iterator;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;

public class Matchers {
    public static ApiResponseMatcher isApiResponse(int expectedHttpStatusCode) {
        return new ApiResponseMatcher().withStatusCode(expectedHttpStatusCode);
    }

    public static ApiResponseMatcher isEmptyResponse(int expectedHttpStatusCode) {
        return new ApiResponseMatcher().withStatusCode(expectedHttpStatusCode).withEmptyBody();
    }

    public static ApiResponseMatcher isRootElementResponse(int expectedHttpStatusCode) {
        return new ApiResponseMatcher().withStatusCode(expectedHttpStatusCode).withOnlyRootElement();
    }

    public static ApiErrorResponseMatcher isApiErrorResponse(int expectedHttpStatusCode) {
        return ApiErrorResponseMatcher.isApiErrorResponse(expectedHttpStatusCode);
    }

    public static <T> Matcher<Collection<T>> collectionEquals(final Collection<T> expectedList, final CollectionComparator<? super T> comparator) {
        return new BaseMatcher<Collection<T>>(){
            private String error;

            public boolean matches(Object item) {
                Collection actualList = (Collection)item;
                Iterator expIterator = expectedList.iterator();
                Iterator actIterator = actualList.iterator();
                int index = 0;
                while (expIterator.hasNext() && actIterator.hasNext()) {
                    Object actObj;
                    Object expObj = expIterator.next();
                    if (!comparator.compare(expObj, actObj = actIterator.next())) {
                        this.error = comparator.describeProblem(expObj, actObj) + " at index " + index;
                        return false;
                    }
                    ++index;
                }
                if (expIterator.hasNext() || actIterator.hasNext()) {
                    this.error = "size does not match at index " + index;
                    return false;
                }
                return true;
            }

            public void describeTo(Description description) {
                if (this.error != null) {
                    description.appendText(this.error);
                }
            }
        };
    }

    public static Matcher<JSONObject> isEmptyJsonObject() {
        return new BaseMatcher<JSONObject>(){

            public boolean matches(Object item) {
                if (item instanceof JSONObject) {
                    return ((JSONObject)item).isEmpty();
                }
                if (item instanceof JSONArray) {
                    return ((JSONArray)item).isEmpty();
                }
                return false;
            }

            public void describeTo(Description description) {
                description.appendText("empty JSON object");
            }
        };
    }

    public static interface CollectionComparator<T> {
        public boolean compare(T var1, T var2);

        public String describeProblem(T var1, T var2);
    }
}

