/*
 * Decompiled with CFR 0.152.
 */
package com.lotaris.api.test.rules;

import com.lotaris.api.test.headers.ApiHeaderConfigurator;
import com.lotaris.api.test.headers.ApiHeadersManager;
import com.lotaris.api.test.headers.IApiHeaderConfiguration;
import com.lotaris.api.test.headers.IApiHeaderConfigurator;
import com.lotaris.api.test.headers.IApiHeaderConfiguratorLocator;
import com.lotaris.api.test.rules.ApiTestHeadersManagerRule;
import java.util.ArrayList;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class ApiTestHeaderConfigurationRule
implements TestRule {
    private IApiHeaderConfiguratorLocator headerConfiguratorLocator;
    private ApiTestHeadersManagerRule headersManagerRule;

    public ApiTestHeaderConfigurationRule(IApiHeaderConfiguratorLocator headerConfiguratorLocator, ApiTestHeadersManagerRule headersManagerRule) {
        this.headerConfiguratorLocator = headerConfiguratorLocator;
        this.headersManagerRule = headersManagerRule;
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                ApiTestHeaderConfigurationRule.this.configureHeaders(description);
                base.evaluate();
            }
        };
    }

    private void configureHeaders(Description description) {
        ApiHeaderConfigurator headerConfigurator = (ApiHeaderConfigurator)description.getAnnotation(ApiHeaderConfigurator.class);
        if (headerConfigurator != null) {
            ArrayList configuratiors = new ArrayList();
            for (Class<? extends IApiHeaderConfigurator> apiConfigClass : headerConfigurator.value()) {
                IApiHeaderConfigurator configurator = this.headerConfiguratorLocator.getHeaderConfigurator(apiConfigClass);
                for (IApiHeaderConfiguration configuration : configurator.getApiHeaderConfigurations()) {
                    this.headersManagerRule.getHeadersManager().configure(ApiHeadersManager.Operation.SET, configuration, true);
                }
            }
        }
    }
}

