/*
 * Decompiled with CFR 0.152.
 */
package com.lotaris.api.test.utils;

import java.util.Map;
import org.junit.Assert;

public class MapUtils {
    public static Map.Entry<String, String> getUniqueEntry(Map<String, String> map) throws IndexOutOfBoundsException {
        if (map == null || map.size() != 1) {
            throw new IndexOutOfBoundsException("The size of the Map should be 1");
        }
        return map.entrySet().iterator().next();
    }

    public static void checkMap(String message, Map<? extends Object, ? extends Object> expectedMap, Map<? extends Object, ? extends Object> actualMap) {
        for (Object object : expectedMap.keySet()) {
            if (expectedMap.get(object).equals(actualMap.get(object))) continue;
            Assert.fail((String)String.format(message, object, expectedMap.get(object), actualMap.get(object)));
        }
        for (Object object : actualMap.keySet()) {
            if (expectedMap.containsKey(object)) continue;
            Assert.fail((String)String.format(message, object, "(null)", actualMap.get(object)));
        }
    }

    public static String mapToString(Map<? extends Object, ? extends Object> map) {
        StringBuilder sb = new StringBuilder();
        if (map == null || map.isEmpty()) {
            return sb.toString();
        }
        for (Object object : map.keySet()) {
            sb.append(object.toString());
            sb.append(" : ");
            sb.append(map.get(object).toString());
            sb.append(" ; ");
        }
        return sb.toString();
    }
}

