/*
 * Decompiled with CFR 0.152.
 */
package io.gsonfire.postprocessors.methodinvoker;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.gsonfire.PostProcessor;
import io.gsonfire.annotations.ExposeMethodResult;
import io.gsonfire.gson.FireExclusionStrategy;
import io.gsonfire.gson.FireExclusionStrategyComposite;
import io.gsonfire.postprocessors.methodinvoker.MappedMethod;
import io.gsonfire.postprocessors.methodinvoker.MappedMethodInspector;
import java.lang.reflect.InvocationTargetException;

public final class MethodInvokerPostProcessor<T>
implements PostProcessor<T> {
    private static MappedMethodInspector methodInspector = new MappedMethodInspector();
    private final FireExclusionStrategy serializationExclusionStrategy;

    public MethodInvokerPostProcessor() {
        this(new FireExclusionStrategyComposite(new FireExclusionStrategy[0]));
    }

    public MethodInvokerPostProcessor(FireExclusionStrategy serializationExclusionStrategy) {
        this.serializationExclusionStrategy = serializationExclusionStrategy;
    }

    @Override
    public void postDeserialize(T result, JsonElement src, Gson gson) {
    }

    @Override
    public void postSerialize(JsonElement result, T src, Gson gson) {
        if (result.isJsonObject()) {
            JsonObject jsonObject = result.getAsJsonObject();
            for (MappedMethod m4 : methodInspector.getAnnotatedMembers(src.getClass(), ExposeMethodResult.class)) {
                if (this.serializationExclusionStrategy.shouldSkipMethod(m4)) continue;
                try {
                    if (m4.getConflictResolutionStrategy() != ExposeMethodResult.ConflictResolutionStrategy.OVERWRITE && (m4.getConflictResolutionStrategy() != ExposeMethodResult.ConflictResolutionStrategy.SKIP || jsonObject.has(m4.getSerializedName()))) continue;
                    Object value = m4.getMethod().invoke(src, new Object[0]);
                    jsonObject.add(m4.getSerializedName(), gson.toJsonTree(value));
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

