/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.extra.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.marklogic.client.MarkLogicIOException;
import com.marklogic.client.io.BaseHandle;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.OutputStreamSender;
import com.marklogic.client.io.marker.BufferableHandle;
import com.marklogic.client.io.marker.ContentHandle;
import com.marklogic.client.io.marker.ContentHandleFactory;
import com.marklogic.client.io.marker.JSONReadHandle;
import com.marklogic.client.io.marker.JSONWriteHandle;
import com.marklogic.client.io.marker.StructureReadHandle;
import com.marklogic.client.io.marker.StructureWriteHandle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public class JacksonHandle
extends BaseHandle<InputStream, OutputStreamSender>
implements OutputStreamSender,
BufferableHandle,
ContentHandle<JsonNode>,
JSONReadHandle,
JSONWriteHandle,
StructureReadHandle,
StructureWriteHandle {
    private JsonNode content;
    private ObjectMapper mapper;

    public static ContentHandleFactory newFactory() {
        return new ContentHandleFactory(){

            @Override
            public Class<?>[] getHandledClasses() {
                return new Class[]{JsonNode.class};
            }

            @Override
            public boolean isHandled(Class<?> type) {
                return JsonNode.class.isAssignableFrom(type);
            }

            @Override
            public <C> ContentHandle<C> newHandle(Class<C> type) {
                JacksonHandle handle = this.isHandled(type) ? new JacksonHandle() : null;
                return handle;
            }
        };
    }

    public JacksonHandle() {
        super.setFormat(Format.JSON);
        this.setResendable(true);
    }

    public JacksonHandle(JsonNode content) {
        this();
        this.set(content);
    }

    public ObjectMapper getMapper() {
        if (this.mapper == null) {
            this.mapper = new ObjectMapper();
        }
        this.mapper.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
        this.mapper.configure(JsonParser.Feature.AUTO_CLOSE_SOURCE, false);
        return this.mapper;
    }

    @Override
    public JsonNode get() {
        return this.content;
    }

    @Override
    public void set(JsonNode content) {
        this.content = content;
    }

    public JacksonHandle with(JsonNode content) {
        this.set(content);
        return this;
    }

    @Override
    public void setFormat(Format format) {
        if (format != Format.JSON) {
            throw new IllegalArgumentException("JacksonHandle supports the JSON format only");
        }
    }

    @Override
    public void fromBuffer(byte[] buffer) {
        if (buffer == null || buffer.length == 0) {
            this.content = null;
        } else {
            this.receiveContent(new ByteArrayInputStream(buffer));
        }
    }

    @Override
    public byte[] toBuffer() {
        try {
            if (this.content == null) {
                return null;
            }
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            this.write(buffer);
            return buffer.toByteArray();
        }
        catch (IOException e) {
            throw new MarkLogicIOException(e);
        }
    }

    public String toString() {
        try {
            return new String(this.toBuffer(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new MarkLogicIOException(e);
        }
    }

    @Override
    protected Class<InputStream> receiveAs() {
        return InputStream.class;
    }

    @Override
    protected void receiveContent(InputStream content) {
        if (content == null) {
            return;
        }
        try {
            this.content = (JsonNode)this.getMapper().readValue((Reader)new InputStreamReader(content, "UTF-8"), JsonNode.class);
        }
        catch (JsonParseException e) {
            throw new MarkLogicIOException(e);
        }
        catch (JsonMappingException e) {
            throw new MarkLogicIOException(e);
        }
        catch (IOException e) {
            throw new MarkLogicIOException(e);
        }
        finally {
            try {
                content.close();
            }
            catch (IOException e) {}
        }
    }

    @Override
    protected OutputStreamSender sendContent() {
        if (this.content == null) {
            throw new IllegalStateException("No document to write");
        }
        return this;
    }

    @Override
    public void write(OutputStream out) throws IOException {
        this.getMapper().writeValue((Writer)new OutputStreamWriter(out, "UTF-8"), (Object)this.content);
    }
}

