/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl;

import com.marklogic.client.DatabaseClientFactory;
import com.marklogic.client.io.BytesHandle;
import com.marklogic.client.io.DOMHandle;
import com.marklogic.client.io.FileHandle;
import com.marklogic.client.io.InputSourceHandle;
import com.marklogic.client.io.InputStreamHandle;
import com.marklogic.client.io.ReaderHandle;
import com.marklogic.client.io.SourceHandle;
import com.marklogic.client.io.StringHandle;
import com.marklogic.client.io.XMLEventReaderHandle;
import com.marklogic.client.io.XMLStreamReaderHandle;
import com.marklogic.client.io.marker.ContentHandle;
import com.marklogic.client.io.marker.ContentHandleFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class HandleFactoryRegistryImpl
implements DatabaseClientFactory.HandleFactoryRegistry {
    private Map<Class<?>, ContentHandleFactory> factories = new HashMap();

    public static DatabaseClientFactory.HandleFactoryRegistry newDefault() {
        return HandleFactoryRegistryImpl.registerDefaults(new HandleFactoryRegistryImpl());
    }

    public static DatabaseClientFactory.HandleFactoryRegistry registerDefaults(DatabaseClientFactory.HandleFactoryRegistry registry) {
        registry.register(BytesHandle.newFactory());
        registry.register(DOMHandle.newFactory());
        registry.register(FileHandle.newFactory());
        registry.register(InputSourceHandle.newFactory());
        registry.register(InputStreamHandle.newFactory());
        registry.register(ReaderHandle.newFactory());
        registry.register(SourceHandle.newFactory());
        registry.register(StringHandle.newFactory());
        registry.register(XMLEventReaderHandle.newFactory());
        registry.register(XMLStreamReaderHandle.newFactory());
        return registry;
    }

    @Override
    public void register(ContentHandleFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("no factory to register");
        }
        this.register(factory, factory.getHandledClasses());
    }

    @Override
    public void register(ContentHandleFactory factory, Class<?> ... types) {
        if (factory == null) {
            throw new IllegalArgumentException("no factory to register");
        }
        if (types == null || types.length == 0) {
            throw new IllegalArgumentException("no types to register");
        }
        for (Class<?> type : types) {
            this.factories.put(type, factory);
        }
    }

    @Override
    public boolean isRegistered(Class<?> type) {
        return this.getRegisteredType(type) != null;
    }

    @Override
    public Set<Class<?>> listRegistered() {
        return this.factories.keySet();
    }

    @Override
    public <C> ContentHandle<C> makeHandle(Class<C> type) {
        ContentHandle<C> handle;
        if (type == null) {
            throw new IllegalArgumentException("Cannot make handle for null class");
        }
        Class<?> registeredType = this.getRegisteredType(type);
        if (registeredType == null) {
            throw new IllegalArgumentException("No factory for class " + type.getName());
        }
        ContentHandleFactory factory = this.factories.get(registeredType);
        if (type != registeredType) {
            this.factories.put(type, factory);
        }
        if ((handle = factory.newHandle(type)) == null) {
            throw new IllegalArgumentException("Factory " + factory.getClass().getName() + " cannot make handle for class " + type.getName());
        }
        return handle;
    }

    @Override
    public void unregister(Class<?> ... types) {
        if (types == null || types.length == 0) {
            return;
        }
        for (Class<?> type : types) {
            this.factories.remove(type);
        }
    }

    @Override
    public DatabaseClientFactory.HandleFactoryRegistry copy() {
        HandleFactoryRegistryImpl copy = new HandleFactoryRegistryImpl();
        copy.factories.putAll(this.factories);
        return copy;
    }

    Class<?> getRegisteredType(Class<?> type) {
        while (type != null && !type.isAssignableFrom(Object.class)) {
            if (this.factories.containsKey(type)) {
                return type;
            }
            Class<?>[] interfaces = type.getInterfaces();
            if (interfaces != null) {
                for (Class<?> interfaceType : interfaces) {
                    if (!this.factories.containsKey(interfaceType)) continue;
                    return interfaceType;
                }
            }
            type = type.getSuperclass();
        }
        return null;
    }
}

