/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl;

import com.marklogic.client.FailedRequestException;
import com.marklogic.client.ForbiddenUserException;
import com.marklogic.client.MarkLogicInternalException;
import com.marklogic.client.ResourceNotFoundException;
import com.marklogic.client.Transaction;
import com.marklogic.client.document.BinaryDocumentManager;
import com.marklogic.client.document.DocumentDescriptor;
import com.marklogic.client.document.ServerTransform;
import com.marklogic.client.impl.DocumentDescriptorImpl;
import com.marklogic.client.impl.DocumentManagerImpl;
import com.marklogic.client.impl.RESTServices;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.marker.BinaryReadHandle;
import com.marklogic.client.io.marker.BinaryWriteHandle;
import com.marklogic.client.io.marker.ContentHandle;
import com.marklogic.client.io.marker.DocumentMetadataReadHandle;
import com.marklogic.client.util.RequestParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BinaryDocumentImpl
extends DocumentManagerImpl<BinaryReadHandle, BinaryWriteHandle>
implements BinaryDocumentManager {
    private static final Logger logger = LoggerFactory.getLogger(BinaryDocumentImpl.class);
    private BinaryDocumentManager.MetadataExtraction metadataExtraction = BinaryDocumentManager.MetadataExtraction.NONE;

    BinaryDocumentImpl(RESTServices services) {
        super(services, Format.BINARY);
    }

    @Override
    public <T> T readAs(String uri, Class<T> as, long start, long length) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        return this.readAs(uri, null, as, start, length);
    }

    @Override
    public <T> T readAs(String uri, DocumentMetadataReadHandle metadataHandle, Class<T> as, long start, long length) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        ContentHandle<T> handle = this.getHandleRegistry().makeHandle(as);
        if (null == this.read(uri, metadataHandle, (BinaryReadHandle)this.castAbstractReadHandle(as, handle), start, length)) {
            return null;
        }
        return handle.get();
    }

    @Override
    public <T extends BinaryReadHandle> T read(String uri, T contentHandle, long start, long length) {
        return this.read(uri, null, contentHandle, null, start, length, null);
    }

    @Override
    public <T extends BinaryReadHandle> T read(String uri, T contentHandle, ServerTransform transform, long start, long length) {
        return this.read(uri, null, contentHandle, transform, start, length, null);
    }

    @Override
    public <T extends BinaryReadHandle> T read(String uri, DocumentMetadataReadHandle metadataHandle, T contentHandle, long start, long length) {
        return this.read(uri, metadataHandle, contentHandle, null, start, length, null);
    }

    @Override
    public <T extends BinaryReadHandle> T read(String uri, DocumentMetadataReadHandle metadataHandle, T contentHandle, ServerTransform transform, long start, long length) {
        return this.read(uri, metadataHandle, contentHandle, transform, start, length, null);
    }

    @Override
    public <T extends BinaryReadHandle> T read(String uri, T contentHandle, long start, long length, Transaction transaction) {
        return this.read(uri, null, contentHandle, null, start, length, transaction);
    }

    @Override
    public <T extends BinaryReadHandle> T read(String uri, T contentHandle, ServerTransform transform, long start, long length, Transaction transaction) {
        return this.read(uri, null, contentHandle, transform, start, length, transaction);
    }

    @Override
    public <T extends BinaryReadHandle> T read(String uri, DocumentMetadataReadHandle metadataHandle, T contentHandle, long start, long length, Transaction transaction) {
        return this.read(uri, metadataHandle, contentHandle, null, start, length, transaction);
    }

    @Override
    public <T extends BinaryReadHandle> T read(String uri, DocumentMetadataReadHandle metadataHandle, T contentHandle, ServerTransform transform, long start, long length, Transaction transaction) {
        return this.read(new DocumentDescriptorImpl(uri, true), metadataHandle, contentHandle, transform, start, length, transaction);
    }

    @Override
    public <T extends BinaryReadHandle> T read(DocumentDescriptor desc, T contentHandle, long start, long length) {
        return this.read(desc, null, contentHandle, null, start, length, null);
    }

    @Override
    public <T extends BinaryReadHandle> T read(DocumentDescriptor desc, T contentHandle, ServerTransform transform, long start, long length) {
        return this.read(desc, null, contentHandle, transform, start, length, null);
    }

    @Override
    public <T extends BinaryReadHandle> T read(DocumentDescriptor desc, DocumentMetadataReadHandle metadataHandle, T contentHandle, long start, long length) {
        return this.read(desc, metadataHandle, contentHandle, null, start, length, null);
    }

    @Override
    public <T extends BinaryReadHandle> T read(DocumentDescriptor desc, DocumentMetadataReadHandle metadataHandle, T contentHandle, ServerTransform transform, long start, long length) {
        return this.read(desc, metadataHandle, contentHandle, transform, start, length, null);
    }

    @Override
    public <T extends BinaryReadHandle> T read(DocumentDescriptor desc, T contentHandle, long start, long length, Transaction transaction) {
        return this.read(desc, null, contentHandle, null, start, length, transaction);
    }

    @Override
    public <T extends BinaryReadHandle> T read(DocumentDescriptor desc, T contentHandle, ServerTransform transform, long start, long length, Transaction transaction) {
        return this.read(desc, null, contentHandle, transform, start, length, transaction);
    }

    @Override
    public <T extends BinaryReadHandle> T read(DocumentDescriptor desc, DocumentMetadataReadHandle metadataHandle, T contentHandle, long start, long length, Transaction transaction) {
        return this.read(desc, metadataHandle, contentHandle, null, start, length, transaction);
    }

    @Override
    public <T extends BinaryReadHandle> T read(DocumentDescriptor desc, DocumentMetadataReadHandle metadataHandle, T contentHandle, ServerTransform transform, long start, long length, Transaction transaction) {
        if (logger.isInfoEnabled()) {
            logger.info("Reading range of binary content for {}", (Object)desc.getUri());
        }
        RequestParameters extraParams = new RequestParameters();
        if (length > 0L) {
            extraParams.put("range", "bytes=" + start + "-" + (start + length - 1L));
        } else {
            extraParams.put("range", "bytes=" + String.valueOf(start));
        }
        return this.read(desc, metadataHandle, contentHandle, transform, transaction, extraParams);
    }

    @Override
    public BinaryDocumentManager.MetadataExtraction getMetadataExtraction() {
        return this.metadataExtraction;
    }

    @Override
    public void setMetadataExtraction(BinaryDocumentManager.MetadataExtraction policy) {
        this.metadataExtraction = policy;
    }

    @Override
    protected RequestParameters getWriteParams() {
        if (this.metadataExtraction == null || this.metadataExtraction == BinaryDocumentManager.MetadataExtraction.NONE) {
            return null;
        }
        RequestParameters params = new RequestParameters();
        if (this.metadataExtraction == BinaryDocumentManager.MetadataExtraction.PROPERTIES) {
            params.put("extract", "properties");
        } else if (this.metadataExtraction == BinaryDocumentManager.MetadataExtraction.DOCUMENT) {
            params.put("extract", "document");
        } else {
            throw new MarkLogicInternalException("Internal error - unknown metadata extraction policy: " + this.metadataExtraction.name());
        }
        return params;
    }
}

