/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.io;

import com.marklogic.client.MarkLogicIOException;
import com.marklogic.client.io.BaseHandle;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.marker.BinaryReadHandle;
import com.marklogic.client.io.marker.BinaryWriteHandle;
import com.marklogic.client.io.marker.BufferableHandle;
import com.marklogic.client.io.marker.ContentHandle;
import com.marklogic.client.io.marker.ContentHandleFactory;
import com.marklogic.client.io.marker.GenericReadHandle;
import com.marklogic.client.io.marker.GenericWriteHandle;
import com.marklogic.client.io.marker.JSONReadHandle;
import com.marklogic.client.io.marker.JSONWriteHandle;
import com.marklogic.client.io.marker.StructureReadHandle;
import com.marklogic.client.io.marker.StructureWriteHandle;
import com.marklogic.client.io.marker.TextReadHandle;
import com.marklogic.client.io.marker.TextWriteHandle;
import com.marklogic.client.io.marker.XMLReadHandle;
import com.marklogic.client.io.marker.XMLWriteHandle;
import java.io.UnsupportedEncodingException;

public class BytesHandle
extends BaseHandle<byte[], byte[]>
implements BufferableHandle,
ContentHandle<byte[]>,
BinaryReadHandle,
BinaryWriteHandle,
GenericReadHandle,
GenericWriteHandle,
JSONReadHandle,
JSONWriteHandle,
TextReadHandle,
TextWriteHandle,
XMLReadHandle,
XMLWriteHandle,
StructureReadHandle,
StructureWriteHandle {
    private byte[] content;

    public static ContentHandleFactory newFactory() {
        return new ContentHandleFactory(){

            @Override
            public Class<?>[] getHandledClasses() {
                return new Class[]{byte[].class};
            }

            @Override
            public boolean isHandled(Class<?> type) {
                return byte[].class.isAssignableFrom(type);
            }

            @Override
            public <C> ContentHandle<C> newHandle(Class<C> type) {
                BytesHandle handle = this.isHandled(type) ? new BytesHandle() : null;
                return handle;
            }
        };
    }

    public BytesHandle() {
        this.setResendable(true);
    }

    public BytesHandle(byte[] content) {
        this();
        this.set(content);
    }

    @Override
    public byte[] get() {
        return this.content;
    }

    @Override
    public void set(byte[] content) {
        this.content = content;
    }

    public BytesHandle with(byte[] content) {
        this.set(content);
        return this;
    }

    public BytesHandle withFormat(Format format) {
        this.setFormat(format);
        return this;
    }

    public BytesHandle withMimetype(String mimetype) {
        this.setMimetype(mimetype);
        return this;
    }

    @Override
    public void fromBuffer(byte[] buffer) {
        this.content = buffer;
    }

    @Override
    public byte[] toBuffer() {
        return this.content;
    }

    public String toString() {
        try {
            return new String(this.content, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new MarkLogicIOException(e);
        }
    }

    @Override
    protected Class<byte[]> receiveAs() {
        return byte[].class;
    }

    @Override
    protected void receiveContent(byte[] content) {
        this.content = content;
    }

    @Override
    protected byte[] sendContent() {
        if (this.content == null || this.content.length == 0) {
            throw new IllegalStateException("No bytes to write");
        }
        return this.content;
    }
}

