/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl;

import com.marklogic.client.MarkLogicIOException;
import com.marklogic.client.document.DocumentManager;
import com.marklogic.client.document.DocumentMetadataPatchBuilder;
import com.marklogic.client.document.DocumentPatchBuilder;
import com.marklogic.client.impl.JSONStringWriter;
import com.marklogic.client.impl.ValueConverter;
import com.marklogic.client.io.DocumentMetadataHandle;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.StringHandle;
import com.marklogic.client.util.EditableNamespaceContext;
import com.marklogic.client.util.IterableNamespaceContext;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.DatatypeConverter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

class DocumentMetadataPatchBuilderImpl
implements DocumentMetadataPatchBuilder {
    protected static final String REST_API_NS = "http://marklogic.com/rest-api";
    protected static final String PROPERTY_API_NS = "http://marklogic.com/xdmp/property";
    protected static final Map<String, String> reserved = new HashMap<String, String>();
    private CallBuilderImpl callBuilder;
    protected List<PatchOperation> operations = new ArrayList<PatchOperation>();
    protected EditableNamespaceContext namespaces;
    protected String libraryNs;
    protected String libraryAt;
    protected Format format;
    protected Set<DocumentManager.Metadata> processedMetadata;
    protected boolean onContent = false;
    protected DocumentPatchBuilder.PathLanguage pathLang = DocumentPatchBuilder.PathLanguage.XPATH;

    DocumentMetadataPatchBuilderImpl(Format format) {
        this.format = format;
        if (format == Format.XML) {
            this.namespaces = this.makeNamespaces();
        }
    }

    @Override
    public IterableNamespaceContext getNamespaces() {
        return this.namespaces;
    }

    @Override
    public void setNamespaces(IterableNamespaceContext namespaces) {
        if (this.format != Format.XML) {
            throw new IllegalArgumentException("Can specify namespaces only for XML patches");
        }
        EditableNamespaceContext newNamespaces = this.makeNamespaces();
        if (namespaces != null) {
            for (String prefix : namespaces.getAllPrefixes()) {
                String nsUri = namespaces.getNamespaceURI(prefix);
                if (!newNamespaces.containsKey(prefix)) {
                    newNamespaces.put(prefix, nsUri);
                    continue;
                }
                if (nsUri.equals(newNamespaces.getNamespaceURI(prefix))) continue;
                throw new IllegalArgumentException("Cannot change namespace URI for change prefix: " + prefix);
            }
        }
        this.namespaces = newNamespaces;
    }

    private EditableNamespaceContext makeNamespaces() {
        EditableNamespaceContext newNamespaces = new EditableNamespaceContext();
        for (Map.Entry<String, String> entry : reserved.entrySet()) {
            newNamespaces.put(entry.getKey(), entry.getValue());
        }
        return newNamespaces;
    }

    @Override
    public DocumentMetadataPatchBuilder library(String ns, String at) {
        this.libraryNs = ns;
        this.libraryAt = at;
        return this;
    }

    @Override
    public DocumentMetadataPatchBuilder addCollection(String ... collections) {
        this.onCollections();
        for (String collection : collections) {
            this.operations.add(new AddCollectionOperation(collection));
        }
        return this;
    }

    @Override
    public DocumentMetadataPatchBuilder deleteCollection(String ... collections) {
        this.onCollections();
        for (String collection : collections) {
            this.operations.add(new DeleteCollectionOperation(collection));
        }
        return this;
    }

    @Override
    public DocumentMetadataPatchBuilder replaceCollection(String oldCollection, String newCollection) {
        this.onCollections();
        this.operations.add(new ReplaceCollectionOperation(oldCollection, newCollection));
        return this;
    }

    @Override
    public DocumentMetadataPatchBuilder addPermission(String role, DocumentMetadataHandle.Capability ... capabilities) {
        this.onPermissions();
        this.operations.add(new AddPermissionOperation(role, capabilities));
        return this;
    }

    @Override
    public DocumentMetadataPatchBuilder deletePermission(String ... roles) {
        this.onPermissions();
        for (String role : roles) {
            this.operations.add(new DeletePermissionOperation(role));
        }
        return this;
    }

    @Override
    public DocumentMetadataPatchBuilder replacePermission(String role, DocumentMetadataHandle.Capability ... newCapabilities) {
        this.onPermissions();
        this.operations.add(new ReplacePermissionOperation(role, role, newCapabilities));
        return this;
    }

    @Override
    public DocumentMetadataPatchBuilder replacePermission(String oldRole, String newRole, DocumentMetadataHandle.Capability ... newCapabilities) {
        this.onPermissions();
        this.operations.add(new ReplacePermissionOperation(oldRole, newRole, newCapabilities));
        return this;
    }

    @Override
    public DocumentMetadataPatchBuilder addPropertyValue(String name, Object value) {
        this.onProperties();
        QName qname = this.asQName(name);
        this.operations.add(qname != null ? new AddPropertyOperation(qname, value) : new AddPropertyOperation(name, value));
        return this;
    }

    @Override
    public DocumentMetadataPatchBuilder addPropertyValue(QName name, Object value) {
        this.onProperties();
        this.operations.add(new AddPropertyOperation(name, value));
        return this;
    }

    @Override
    public DocumentMetadataPatchBuilder deleteProperty(String ... names) {
        this.onProperties();
        for (String name : names) {
            QName qname = this.asQName(name);
            this.operations.add(qname != null ? new DeletePropertyOperation(qname) : new DeletePropertyOperation(name));
        }
        return this;
    }

    @Override
    public DocumentMetadataPatchBuilder deleteProperty(QName ... names) {
        this.onProperties();
        for (QName name : names) {
            this.operations.add(new DeletePropertyOperation(name));
        }
        return this;
    }

    @Override
    public DocumentMetadataPatchBuilder replacePropertyValue(String name, Object newValue) {
        this.onProperties();
        QName qname = this.asQName(name);
        this.operations.add(qname != null ? new ReplacePropertyOperation(qname, qname, newValue) : new ReplacePropertyOperation(name, name, newValue));
        return this;
    }

    @Override
    public DocumentMetadataPatchBuilder replacePropertyValue(QName name, Object newValue) {
        this.onProperties();
        this.operations.add(new ReplacePropertyOperation(name, name, newValue));
        return this;
    }

    @Override
    public DocumentMetadataPatchBuilder replacePropertyValue(String oldName, String newName, Object newValue) {
        this.onProperties();
        QName oldQName = this.asQName(oldName);
        QName newQName = this.asQName(newName);
        this.operations.add(oldQName != null && newQName != null ? new ReplacePropertyOperation(oldQName, newQName, newValue) : new ReplacePropertyOperation(oldName, newName, newValue));
        return this;
    }

    @Override
    public DocumentMetadataPatchBuilder replacePropertyValue(QName oldName, QName newName, Object newValue) {
        this.onProperties();
        this.operations.add(new ReplacePropertyOperation(oldName, newName, newValue));
        return this;
    }

    @Override
    public DocumentMetadataPatchBuilder replacePropertyApply(String name, DocumentMetadataPatchBuilder.Call call) {
        if (!CallImpl.class.isAssignableFrom(call.getClass())) {
            throw new IllegalArgumentException("Cannot use external call implementation");
        }
        this.onProperties();
        this.operations.add(new ReplacePropertyApplyOperation(name, (CallImpl)call));
        return this;
    }

    @Override
    public DocumentMetadataPatchBuilder replacePropertyApply(QName name, DocumentMetadataPatchBuilder.Call call) {
        if (!CallImpl.class.isAssignableFrom(call.getClass())) {
            throw new IllegalArgumentException("Cannot use external call implementation");
        }
        this.onProperties();
        this.operations.add(new ReplacePropertyApplyOperation(name, (CallImpl)call));
        return this;
    }

    @Override
    public DocumentMetadataPatchBuilder setQuality(int quality) {
        this.onQuality();
        this.operations.add(new SetQualityOperation(quality));
        return this;
    }

    private void onMetadata(DocumentManager.Metadata category) {
        if (this.processedMetadata == null) {
            this.processedMetadata = new HashSet<DocumentManager.Metadata>();
        } else if (this.processedMetadata.contains((Object)category)) {
            return;
        }
        this.processedMetadata.add(category);
    }

    private void onCollections() {
        this.onMetadata(DocumentManager.Metadata.COLLECTIONS);
    }

    private void onPermissions() {
        this.onMetadata(DocumentManager.Metadata.PERMISSIONS);
    }

    private void onProperties() {
        this.onMetadata(DocumentManager.Metadata.PROPERTIES);
    }

    private void onQuality() {
        this.onMetadata(DocumentManager.Metadata.QUALITY);
    }

    @Override
    public DocumentMetadataPatchBuilder.PatchHandle build() throws MarkLogicIOException {
        DocumentPatchHandleImpl handle = new DocumentPatchHandleImpl(this.processedMetadata, this.onContent);
        if (this.format == Format.JSON) {
            handle.setFormat(this.format);
            JSONStringWriter writer = new JSONStringWriter(this.pathLang);
            writer.writeStartObject();
            writer.writeStartEntry("pathlang");
            writer.writeStringValue(this.pathLang.toString());
            writer.writeStartEntry("patch");
            writer.writeStartArray();
            if (this.libraryNs != null && this.libraryAt != null) {
                writer.writeStartObject();
                writer.writeStartEntry("replace-library");
                writer.writeStartObject();
                writer.writeStartEntry("ns");
                writer.writeStringValue(this.libraryNs);
                writer.writeStartEntry("at");
                writer.writeStringValue(this.libraryAt);
                writer.writeEndObject();
                writer.writeEndObject();
            }
            for (PatchOperation operation : this.operations) {
                writer.writeStartItem();
                operation.write(writer);
            }
            writer.writeEndArray();
            writer.writeEndObject();
            handle.set(writer.toString());
        } else {
            handle.setFormat(Format.XML);
            try {
                XMLOutputFactory factory = XMLOutputFactory.newInstance();
                factory.setProperty("javax.xml.stream.isRepairingNamespaces", true);
                StringWriter writer = new StringWriter();
                XMLStreamWriter serializer = factory.createXMLStreamWriter(writer);
                XMLOutputSerializer out = new XMLOutputSerializer(writer, serializer);
                for (String nsPrefix : this.namespaces.getAllPrefixes()) {
                    serializer.setPrefix(nsPrefix, this.namespaces.getNamespaceURI(nsPrefix));
                }
                serializer.writeStartDocument("utf-8", "1.0");
                serializer.writeStartElement("rapi", "patch", REST_API_NS);
                if (this.libraryNs != null && this.libraryAt != null) {
                    serializer.writeStartElement("rapi", "replace-library", REST_API_NS);
                    serializer.writeAttribute("ns", this.libraryNs);
                    serializer.writeAttribute("at", this.libraryAt);
                    serializer.writeEndElement();
                }
                for (PatchOperation operation : this.operations) {
                    operation.write(out);
                }
                serializer.writeEndElement();
                serializer.writeEndDocument();
                serializer.flush();
                serializer.close();
                handle.set(writer.toString());
            }
            catch (Exception e) {
                throw new MarkLogicIOException(e);
            }
        }
        return handle;
    }

    protected QName asQName(String name) {
        String nsUri;
        int pos = name.indexOf(":");
        if (pos != -1) {
            String prefix = name.substring(0, pos);
            String nsUri2 = this.namespaces.getNamespaceURI(prefix);
            if (!"".equals(nsUri2)) {
                return new QName(nsUri2, name.substring(pos + 1), prefix);
            }
            throw new IllegalArgumentException("no namespace binding for prefix: " + prefix);
        }
        if (this.namespaces != null && !"".equals(nsUri = this.namespaces.getNamespaceURI(""))) {
            return new QName(nsUri, name);
        }
        return null;
    }

    @Override
    public DocumentMetadataPatchBuilder.CallBuilder call() {
        if (this.callBuilder == null) {
            this.callBuilder = new CallBuilderImpl();
        }
        return this.callBuilder;
    }

    static {
        reserved.put("rapi", REST_API_NS);
        reserved.put("prop", PROPERTY_API_NS);
        reserved.put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        reserved.put("xs", "http://www.w3.org/2001/XMLSchema");
    }

    static class CallBuilderImpl
    implements DocumentMetadataPatchBuilder.CallBuilder {
        CallBuilderImpl() {
        }

        @Override
        public DocumentMetadataPatchBuilder.Call add(Number number) {
            if (number == null) {
                throw new IllegalArgumentException("Cannot add null number");
            }
            return new CallImpl("ml.add", false, number);
        }

        @Override
        public DocumentMetadataPatchBuilder.Call subtract(Number number) {
            if (number == null) {
                throw new IllegalArgumentException("Cannot subtract null number");
            }
            return new CallImpl("ml.subtract", false, number);
        }

        @Override
        public DocumentMetadataPatchBuilder.Call multiply(Number number) {
            if (number == null) {
                throw new IllegalArgumentException("Cannot multiply null number");
            }
            return new CallImpl("ml.multiply", false, number);
        }

        @Override
        public DocumentMetadataPatchBuilder.Call divideBy(Number number) {
            if (number == null) {
                throw new IllegalArgumentException("Cannot divide null number");
            }
            return new CallImpl("ml.divide", false, number);
        }

        @Override
        public DocumentMetadataPatchBuilder.Call concatenateAfter(String prefix) {
            if (prefix == null) {
                throw new IllegalArgumentException("Cannot concatenate after null prefix");
            }
            return new CallImpl("ml.concat-after", false, prefix);
        }

        @Override
        public DocumentMetadataPatchBuilder.Call concatenateBetween(String prefix, String suffix) {
            if (prefix == null || suffix == null) {
                throw new IllegalArgumentException("Cannot concatenate between null prefix or suffix");
            }
            return new CallImpl("ml.concat-between", false, prefix, suffix);
        }

        @Override
        public DocumentMetadataPatchBuilder.Call concatenateBefore(String suffix) {
            if (suffix == null) {
                throw new IllegalArgumentException("Cannot concatenate before null suffix");
            }
            return new CallImpl("ml.concat-before", false, suffix);
        }

        @Override
        public DocumentMetadataPatchBuilder.Call substringAfter(String prefix) {
            if (prefix == null) {
                throw new IllegalArgumentException("Cannot substring after null prefix");
            }
            return new CallImpl("ml.substring-after", false, prefix);
        }

        @Override
        public DocumentMetadataPatchBuilder.Call substringBefore(String suffix) {
            if (suffix == null) {
                throw new IllegalArgumentException("Cannot substring before null suffix");
            }
            return new CallImpl("ml.substring-before", false, suffix);
        }

        @Override
        public DocumentMetadataPatchBuilder.Call replaceRegex(String pattern, String replacement) {
            if (pattern == null || replacement == null) {
                throw new IllegalArgumentException("Cannot replace regex with null pattern or replacement");
            }
            return new CallImpl("ml.replace-regex", false, pattern, replacement);
        }

        @Override
        public DocumentMetadataPatchBuilder.Call replaceRegex(String pattern, String replacement, String flags) {
            if (pattern == null || replacement == null || flags == null) {
                throw new IllegalArgumentException("Cannot replace regex with null pattern, replacement, or flags");
            }
            return new CallImpl("ml.replace-regex", false, pattern, replacement, flags);
        }

        @Override
        public DocumentMetadataPatchBuilder.Call applyLibrary(String function) {
            return new CallImpl(function);
        }

        @Override
        public DocumentMetadataPatchBuilder.Call applyLibraryValues(String function, Object ... args) {
            return new CallImpl(function, false, args);
        }

        @Override
        public DocumentMetadataPatchBuilder.Call applyLibraryFragments(String function, Object ... args) {
            return new CallImpl(function, true, args);
        }
    }

    static class CallImpl
    implements DocumentMetadataPatchBuilder.Call {
        String function;
        boolean isFragment = true;
        Object[] args;

        CallImpl(String function) {
            this.function = function;
        }

        CallImpl(String function, boolean isFragment, Object ... args) {
            this(function);
            this.isFragment = isFragment;
            this.args = args;
        }
    }

    static class DocumentPatchHandleImpl
    extends StringHandle
    implements DocumentMetadataPatchBuilder.PatchHandle {
        private Set<DocumentManager.Metadata> metadata;
        private boolean onContent;

        DocumentPatchHandleImpl(Set<DocumentManager.Metadata> metadata, boolean onContent) {
            this.metadata = metadata;
            this.onContent = onContent;
        }

        Set<DocumentManager.Metadata> getMetadata() {
            return this.metadata;
        }

        public boolean isOnContent() {
            return this.onContent;
        }
    }

    static class SetQualityOperation
    extends PatchOperation {
        int quality;

        SetQualityOperation(int quality) {
            this.quality = quality;
        }

        @Override
        public void write(JSONStringWriter serializer) {
            String pathString = serializer.getPathLanguage() == DocumentPatchBuilder.PathLanguage.JSONPATH ? "$.quality" : "/node('quality')";
            this.writeStartReplace(serializer, pathString, null);
            serializer.writeStartEntry("content");
            serializer.writeNumberValue(this.quality);
            serializer.writeEndObject();
            serializer.writeEndObject();
        }

        @Override
        public void write(XMLOutputSerializer out) throws Exception {
            XMLStreamWriter serializer = out.getSerializer();
            this.writeStartReplace(out, "/rapi:metadata/rapi:quality", null);
            serializer.writeCharacters(String.valueOf(this.quality));
            serializer.writeEndElement();
        }
    }

    static class ReplacePropertyApplyOperation
    extends PatchOperation {
        QName qname;
        String name;
        CallImpl call;

        ReplacePropertyApplyOperation(CallImpl call) {
            this.call = call;
        }

        ReplacePropertyApplyOperation(String name, CallImpl call) {
            this(call);
            this.name = name;
        }

        ReplacePropertyApplyOperation(QName qname, CallImpl call) {
            this(call);
            this.qname = qname;
        }

        @Override
        public void write(JSONStringWriter serializer) {
            String pathString = serializer.getPathLanguage() == DocumentPatchBuilder.PathLanguage.JSONPATH ? "$.properties.[" + JSONStringWriter.toJSON(this.name) + "]" : "/properties/node(" + JSONStringWriter.toJSON(this.name) + ")";
            this.writeReplaceApply(serializer, pathString, null, this.call);
        }

        @Override
        public void write(XMLOutputSerializer out) throws Exception {
            this.writeReplaceApply(out, "/rapi:metadata/prop:properties/" + this.getLexicalName(this.qname, this.name), null, this.call);
        }
    }

    static class ReplacePropertyOperation
    extends PatchOperation {
        QName oldQName;
        QName newQName;
        String oldName;
        String newName;
        Object newValue;

        ReplacePropertyOperation(Object newValue) {
            this.newValue = newValue;
        }

        ReplacePropertyOperation(String oldName, String newName, Object newValue) {
            this(newValue);
            this.oldName = oldName;
            this.newName = newName;
        }

        ReplacePropertyOperation(QName oldQName, QName newQName, Object newValue) {
            this(newValue);
            this.oldQName = oldQName;
            this.newQName = newQName;
        }

        @Override
        public void write(JSONStringWriter serializer) {
            String pathString = serializer.getPathLanguage() == DocumentPatchBuilder.PathLanguage.JSONPATH ? "$.properties.[" + JSONStringWriter.toJSON(this.oldName) + "]" : "/properties/node(" + JSONStringWriter.toJSON(this.oldName) + ")";
            this.writeStartReplace(serializer, pathString, null);
            serializer.writeStartEntry("content");
            serializer.writeStartObject();
            serializer.writeStartEntry(this.newName);
            serializer.writeStringValue(this.newValue.toString());
            serializer.writeEndObject();
            serializer.writeEndObject();
            serializer.writeEndObject();
        }

        @Override
        public void write(XMLOutputSerializer out) throws Exception {
            XMLStreamWriter serializer = out.getSerializer();
            this.writeStartReplace(out, "/rapi:metadata/prop:properties/" + this.getLexicalName(this.oldQName, this.oldName), null);
            this.writeStartElement(out, this.newQName, this.newName);
            this.convertFromJava(out, this.newValue);
            serializer.writeEndElement();
            serializer.writeEndElement();
        }
    }

    static class DeletePropertyOperation
    extends PatchOperation {
        QName qname;
        String name;

        DeletePropertyOperation() {
        }

        DeletePropertyOperation(String name) {
            this();
            this.name = name;
        }

        DeletePropertyOperation(QName qname) {
            this();
            this.qname = qname;
        }

        @Override
        public void write(JSONStringWriter serializer) {
            String pathString = serializer.getPathLanguage() == DocumentPatchBuilder.PathLanguage.JSONPATH ? "$.properties.[" + JSONStringWriter.toJSON(this.name) + "]" : "/properties/node(" + JSONStringWriter.toJSON(this.name) + ")";
            this.writeDelete(serializer, pathString, null);
        }

        @Override
        public void write(XMLOutputSerializer out) throws Exception {
            this.writeDelete(out, "/rapi:metadata/prop:properties/" + this.getLexicalName(this.qname, this.name), null);
        }
    }

    static class AddPropertyOperation
    extends PatchOperation {
        QName qname;
        String name;
        Object value;

        AddPropertyOperation(Object value) {
            this.value = value;
        }

        AddPropertyOperation(String name, Object value) {
            this(value);
            this.name = name;
        }

        AddPropertyOperation(QName qname, Object value) {
            this(value);
            this.qname = qname;
        }

        @Override
        public void write(JSONStringWriter serializer) {
            String pathString = serializer.getPathLanguage() == DocumentPatchBuilder.PathLanguage.JSONPATH ? "$.properties" : "/array-node('properties')";
            this.writeStartInsert(serializer, pathString, "last-child", null);
            serializer.writeStartEntry("content");
            serializer.writeStartObject();
            serializer.writeStartEntry(this.name);
            serializer.writeStringValue(this.value.toString());
            serializer.writeEndObject();
            serializer.writeEndObject();
            serializer.writeEndObject();
        }

        @Override
        public void write(XMLOutputSerializer out) throws Exception {
            XMLStreamWriter serializer = out.getSerializer();
            this.writeStartInsert(out, "/rapi:metadata/prop:properties", "last-child", null);
            this.writeStartElement(out, this.qname, this.name);
            this.convertFromJava(out, this.value);
            serializer.writeEndElement();
            serializer.writeEndElement();
        }
    }

    static class ReplacePermissionOperation
    extends PatchOperation {
        String oldRole;
        String newRole;
        DocumentMetadataHandle.Capability[] newCapabilities;

        ReplacePermissionOperation(String oldRole, String newRole, DocumentMetadataHandle.Capability ... newCapabilities) {
            this.oldRole = oldRole;
            this.newRole = newRole;
            this.newCapabilities = newCapabilities;
        }

        @Override
        public void write(JSONStringWriter serializer) {
            String pathString = serializer.getPathLanguage() == DocumentPatchBuilder.PathLanguage.JSONPATH ? "$.permissions[?(role-name=" + JSONStringWriter.toJSON(this.oldRole) + ")]" : "/permissions[role-name = " + JSONStringWriter.toJSON(this.oldRole) + "]";
            this.writeStartReplace(serializer, pathString, null);
            serializer.writeStartEntry("content");
            serializer.writeStartObject();
            serializer.writeStartEntry("role-name");
            serializer.writeStringValue(this.newRole);
            serializer.writeStartEntry("capabilities");
            serializer.writeStartArray();
            for (DocumentMetadataHandle.Capability capability : this.newCapabilities) {
                serializer.writeStartItem();
                serializer.writeStringValue(capability.toString().toLowerCase());
            }
            serializer.writeEndArray();
            serializer.writeEndObject();
            serializer.writeEndObject();
            serializer.writeEndObject();
        }

        @Override
        public void write(XMLOutputSerializer out) throws Exception {
            XMLStreamWriter serializer = out.getSerializer();
            this.writeStartReplace(out, "/rapi:metadata/rapi:permissions/rapi:permission[rapi:role-name='" + this.oldRole + "']", null);
            serializer.writeStartElement("rapi", "permission", DocumentMetadataPatchBuilderImpl.REST_API_NS);
            serializer.writeStartElement("rapi", "role-name", DocumentMetadataPatchBuilderImpl.REST_API_NS);
            serializer.writeCharacters(this.newRole);
            serializer.writeEndElement();
            for (DocumentMetadataHandle.Capability capability : this.newCapabilities) {
                serializer.writeStartElement("rapi", "capability", DocumentMetadataPatchBuilderImpl.REST_API_NS);
                serializer.writeCharacters(capability.toString().toLowerCase());
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
            serializer.writeEndElement();
        }
    }

    static class DeletePermissionOperation
    extends PatchOperation {
        String role;

        DeletePermissionOperation(String role) {
            this.role = role;
        }

        @Override
        public void write(JSONStringWriter serializer) {
            String pathString = serializer.getPathLanguage() == DocumentPatchBuilder.PathLanguage.JSONPATH ? "$.permissions.[*][?(@.role-name=" + JSONStringWriter.toJSON(this.role) + ")]" : "/permissions[role-name = " + JSONStringWriter.toJSON(this.role) + "]";
            this.writeDelete(serializer, pathString, null);
        }

        @Override
        public void write(XMLOutputSerializer out) throws Exception {
            this.writeDelete(out, "/rapi:metadata/rapi:permissions/rapi:permission[rapi:role-name='" + this.role + "']", null);
        }
    }

    static class AddPermissionOperation
    extends PatchOperation {
        String role;
        DocumentMetadataHandle.Capability[] capabilities;

        AddPermissionOperation(String role, DocumentMetadataHandle.Capability ... capabilities) {
            this.role = role;
            this.capabilities = capabilities;
        }

        @Override
        public void write(JSONStringWriter serializer) {
            String pathString = serializer.getPathLanguage() == DocumentPatchBuilder.PathLanguage.JSONPATH ? "$.permissions" : "/array-node('permissions')";
            this.writeStartInsert(serializer, pathString, "last-child", null);
            serializer.writeStartEntry("content");
            serializer.writeStartObject();
            serializer.writeStartEntry("role-name");
            serializer.writeStringValue(this.role);
            serializer.writeStartEntry("capabilities");
            serializer.writeStartArray();
            for (DocumentMetadataHandle.Capability capability : this.capabilities) {
                serializer.writeStartItem();
                serializer.writeStringValue(capability.toString().toLowerCase());
            }
            serializer.writeEndArray();
            serializer.writeEndObject();
            serializer.writeEndObject();
            serializer.writeEndObject();
        }

        @Override
        public void write(XMLOutputSerializer out) throws Exception {
            XMLStreamWriter serializer = out.getSerializer();
            this.writeStartInsert(out, "/rapi:metadata/rapi:permissions", "last-child", null);
            serializer.writeStartElement("rapi", "permission", DocumentMetadataPatchBuilderImpl.REST_API_NS);
            serializer.writeStartElement("rapi", "role-name", DocumentMetadataPatchBuilderImpl.REST_API_NS);
            serializer.writeCharacters(this.role);
            serializer.writeEndElement();
            for (DocumentMetadataHandle.Capability capability : this.capabilities) {
                serializer.writeStartElement("rapi", "capability", DocumentMetadataPatchBuilderImpl.REST_API_NS);
                serializer.writeCharacters(capability.toString().toLowerCase());
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
            serializer.writeEndElement();
        }
    }

    static class ReplaceCollectionOperation
    extends PatchOperation {
        String oldCollection;
        String newCollection;

        ReplaceCollectionOperation(String oldCollection, String newCollection) {
            this.oldCollection = oldCollection;
            this.newCollection = newCollection;
        }

        @Override
        public void write(JSONStringWriter serializer) {
            String pathString = serializer.getPathLanguage() == DocumentPatchBuilder.PathLanguage.JSONPATH ? "$.collections[?(@=" + JSONStringWriter.toJSON(this.oldCollection) + ")]" : "/collections[. eq " + JSONStringWriter.toJSON(this.oldCollection) + "]";
            this.writeStartReplace(serializer, pathString, null);
            serializer.writeStartEntry("content");
            serializer.writeStringValue(this.newCollection);
            serializer.writeEndObject();
            serializer.writeEndObject();
        }

        @Override
        public void write(XMLOutputSerializer out) throws Exception {
            XMLStreamWriter serializer = out.getSerializer();
            this.writeStartReplace(out, "/rapi:metadata/rapi:collections/rapi:collection[.='" + this.oldCollection + "']", null);
            serializer.writeStartElement("rapi", "collection", DocumentMetadataPatchBuilderImpl.REST_API_NS);
            serializer.writeCharacters(this.newCollection);
            serializer.writeEndElement();
            serializer.writeEndElement();
        }
    }

    static class DeleteCollectionOperation
    extends PatchOperation {
        String collection;

        DeleteCollectionOperation(String collection) {
            this.collection = collection;
        }

        @Override
        public void write(JSONStringWriter serializer) {
            String pathString = serializer.getPathLanguage() == DocumentPatchBuilder.PathLanguage.JSONPATH ? "$.collections[*][?(@=" + JSONStringWriter.toJSON(this.collection) + ")]" : "/collections[. = " + JSONStringWriter.toJSON(this.collection) + "]";
            this.writeDelete(serializer, pathString, null);
        }

        @Override
        public void write(XMLOutputSerializer out) throws Exception {
            this.writeDelete(out, "/rapi:metadata/rapi:collections/rapi:collection[.='" + DatatypeConverter.printString((String)this.collection) + "']", null);
        }
    }

    static class AddCollectionOperation
    extends PatchOperation {
        String collection;

        AddCollectionOperation(String collection) {
            this.collection = collection;
        }

        @Override
        public void write(JSONStringWriter serializer) {
            String pathString = serializer.getPathLanguage() == DocumentPatchBuilder.PathLanguage.JSONPATH ? "$.[\"collections\"]" : "/array-node('collections')";
            this.writeStartInsert(serializer, pathString, "last-child", null);
            serializer.writeStartEntry("content");
            serializer.writeStringValue(this.collection);
            serializer.writeEndObject();
            serializer.writeEndObject();
        }

        @Override
        public void write(XMLOutputSerializer out) throws Exception {
            XMLStreamWriter serializer = out.getSerializer();
            this.writeStartInsert(out, "/rapi:metadata/rapi:collections", "last-child", null);
            serializer.writeStartElement("rapi", "collection", DocumentMetadataPatchBuilderImpl.REST_API_NS);
            serializer.writeCharacters(this.collection);
            serializer.writeEndElement();
            serializer.writeEndElement();
        }
    }

    static abstract class PatchOperation
    implements ValueConverter.ValueProcessor {
        private XMLOutputSerializer out;

        PatchOperation() {
        }

        public abstract void write(JSONStringWriter var1);

        public abstract void write(XMLOutputSerializer var1) throws Exception;

        public void writeDelete(JSONStringWriter serializer, String select, DocumentMetadataPatchBuilder.Cardinality cardinality) {
            serializer.writeStartObject();
            serializer.writeStartEntry("delete");
            serializer.writeStartObject();
            serializer.writeStartEntry("select");
            serializer.writeStringValue(select);
            if (cardinality != null) {
                serializer.writeStartEntry("cardinality");
                serializer.writeStringValue(cardinality.abbreviate());
            }
            serializer.writeEndObject();
            serializer.writeEndObject();
        }

        public void writeDelete(XMLOutputSerializer out, String select, DocumentMetadataPatchBuilder.Cardinality cardinality) throws Exception {
            XMLStreamWriter serializer = out.getSerializer();
            serializer.writeStartElement("rapi", "delete", DocumentMetadataPatchBuilderImpl.REST_API_NS);
            serializer.writeAttribute("select", select);
            if (cardinality != null) {
                serializer.writeAttribute("cardinality", cardinality.abbreviate());
            }
            serializer.writeEndElement();
        }

        public void writeStartInsert(JSONStringWriter serializer, String context, String position, DocumentMetadataPatchBuilder.Cardinality cardinality) {
            serializer.writeStartObject();
            serializer.writeStartEntry("insert");
            serializer.writeStartObject();
            serializer.writeStartEntry("context");
            serializer.writeStringValue(context);
            serializer.writeStartEntry("position");
            serializer.writeStringValue(position);
            if (cardinality != null) {
                serializer.writeStartEntry("cardinality");
                serializer.writeStringValue(cardinality.abbreviate());
            }
        }

        public void writeStartInsert(XMLOutputSerializer out, String context, String position, DocumentMetadataPatchBuilder.Cardinality cardinality) throws Exception {
            XMLStreamWriter serializer = out.getSerializer();
            serializer.writeStartElement("rapi", "insert", DocumentMetadataPatchBuilderImpl.REST_API_NS);
            serializer.writeAttribute("context", context);
            serializer.writeAttribute("position", position);
            if (cardinality != null) {
                serializer.writeAttribute("cardinality", cardinality.abbreviate());
            }
        }

        public void writeStartReplace(JSONStringWriter serializer, String select, DocumentMetadataPatchBuilder.Cardinality cardinality) {
            serializer.writeStartObject();
            serializer.writeStartEntry("replace");
            serializer.writeStartObject();
            serializer.writeStartEntry("select");
            serializer.writeStringValue(select);
            if (cardinality != null) {
                serializer.writeStartEntry("cardinality");
                serializer.writeStringValue(cardinality.abbreviate());
            }
        }

        public void writeStartReplace(XMLOutputSerializer out, String select, DocumentMetadataPatchBuilder.Cardinality cardinality) throws Exception {
            XMLStreamWriter serializer = out.getSerializer();
            serializer.writeStartElement("rapi", "replace", DocumentMetadataPatchBuilderImpl.REST_API_NS);
            serializer.writeAttribute("select", select);
            if (cardinality != null) {
                serializer.writeAttribute("cardinality", cardinality.abbreviate());
            }
        }

        public void writeStartReplaceInsert(JSONStringWriter serializer, String select, String context, String position, DocumentMetadataPatchBuilder.Cardinality cardinality) {
            serializer.writeStartObject();
            serializer.writeStartEntry("replace-insert");
            serializer.writeStartObject();
            serializer.writeStartEntry("select");
            serializer.writeStringValue(select);
            serializer.writeStartEntry("context");
            serializer.writeStringValue(context);
            serializer.writeStartEntry("position");
            serializer.writeStringValue(position);
            if (cardinality != null) {
                serializer.writeStartEntry("cardinality");
                serializer.writeStringValue(cardinality.abbreviate());
            }
        }

        public void writeStartReplaceInsert(XMLOutputSerializer out, String select, String context, String position, DocumentMetadataPatchBuilder.Cardinality cardinality) throws Exception {
            XMLStreamWriter serializer = out.getSerializer();
            serializer.writeStartElement("rapi", "replace-insert", DocumentMetadataPatchBuilderImpl.REST_API_NS);
            serializer.writeAttribute("select", select);
            serializer.writeAttribute("context", context);
            serializer.writeAttribute("position", position);
            if (cardinality != null) {
                serializer.writeAttribute("cardinality", cardinality.abbreviate());
            }
        }

        public void writeReplaceApply(JSONStringWriter serializer, String select, DocumentMetadataPatchBuilder.Cardinality cardinality, CallImpl call) {
            if (call == null) {
                throw new IllegalArgumentException("Cannot apply a null call to a function");
            }
            serializer.writeStartObject();
            serializer.writeStartEntry("replace");
            serializer.writeStartObject();
            serializer.writeStartEntry("select");
            serializer.writeStringValue(select);
            if (cardinality != null) {
                serializer.writeStartEntry("cardinality");
                serializer.writeStringValue(cardinality.abbreviate());
            }
            serializer.writeStartEntry("apply");
            serializer.writeStringValue(call.function);
            if (call.args != null && call.args.length > 0) {
                serializer.writeStartEntry("content");
                this.writeCall(serializer, call);
            }
            serializer.writeEndObject();
            serializer.writeEndObject();
        }

        public void writeReplaceApply(XMLOutputSerializer out, String select, DocumentMetadataPatchBuilder.Cardinality cardinality, CallImpl call) throws Exception {
            if (call == null) {
                throw new IllegalArgumentException("Cannot apply a null call to a function");
            }
            XMLStreamWriter serializer = out.getSerializer();
            serializer.writeStartElement("rapi", "replace", DocumentMetadataPatchBuilderImpl.REST_API_NS);
            serializer.writeAttribute("select", select);
            if (cardinality != null) {
                serializer.writeAttribute("cardinality", cardinality.abbreviate());
            }
            serializer.writeAttribute("apply", call.function);
            if (call.args != null && call.args.length > 0) {
                this.writeCall(out, call);
            }
            serializer.writeEndElement();
        }

        public void writeCall(JSONStringWriter serializer, CallImpl call) {
            if (call == null) {
                return;
            }
            if (call.isFragment) {
                if (call.args.length == 1) {
                    serializer.writeFragment(call.args[0] instanceof String ? (String)call.args[0] : call.args[0].toString());
                } else {
                    serializer.writeStartArray();
                    for (Object fragment : call.args) {
                        serializer.writeFragment(fragment instanceof String ? (String)fragment : fragment.toString());
                    }
                    serializer.writeEndArray();
                }
            } else if (call.args.length == 1) {
                serializer.writeStringValue(call.args[0]);
            } else {
                serializer.writeStartArray();
                for (Object value : call.args) {
                    serializer.writeStartObject();
                    serializer.writeStartEntry("value");
                    serializer.writeStringValue(value);
                    serializer.writeEndObject();
                }
                serializer.writeEndArray();
            }
        }

        public void writeCall(XMLOutputSerializer out, CallImpl call) throws Exception {
            if (call == null) {
                return;
            }
            XMLStreamWriter serializer = out.getSerializer();
            if (call.isFragment) {
                serializer.writeCharacters("");
                for (Object fragment : call.args) {
                    out.getWriter().write(fragment instanceof String ? (String)fragment : fragment.toString());
                }
            } else if (call.args.length == 1) {
                this.convertFromJava(out, call.args[0]);
            } else {
                for (Object value : call.args) {
                    serializer.writeStartElement("rapi", "value", DocumentMetadataPatchBuilderImpl.REST_API_NS);
                    this.convertFromJava(out, value);
                    serializer.writeEndElement();
                }
            }
        }

        public void writeStartElement(XMLOutputSerializer out, QName qname, String name) throws Exception {
            XMLStreamWriter serializer = out.getSerializer();
            if (qname != null) {
                String nsUri = qname.getNamespaceURI();
                if (nsUri != null && nsUri.length() > 0) {
                    serializer.writeStartElement(qname.getPrefix(), qname.getLocalPart(), nsUri);
                } else {
                    serializer.writeStartElement(qname.getLocalPart());
                }
            } else {
                serializer.writeStartElement(name);
            }
        }

        public String getLexicalName(QName qname, String name) {
            if (qname == null) {
                return name;
            }
            String prefix = qname.getPrefix();
            return prefix == null ? qname.getLocalPart() : prefix + ":" + qname.getLocalPart();
        }

        protected void convertFromJava(XMLOutputSerializer out, Object value) {
            this.out = out;
            ValueConverter.convertFromJava(value, (ValueConverter.ValueProcessor)this);
            this.out = null;
        }

        @Override
        public void process(Object original, String type, String value) {
            XMLStreamWriter serializer = this.out.getSerializer();
            if (original == null) {
                return;
            }
            try {
                serializer.writeAttribute("xsi", "http://www.w3.org/2001/XMLSchema-instance", "type", type);
                serializer.writeCharacters(value);
            }
            catch (XMLStreamException e) {
                throw new MarkLogicIOException(e);
            }
        }
    }

    static class XMLOutputSerializer {
        private StringWriter writer;
        private XMLStreamWriter serializer;

        XMLOutputSerializer(StringWriter writer, XMLStreamWriter serializer) throws XMLStreamException {
            this.writer = writer;
            this.serializer = serializer;
        }

        StringWriter getWriter() throws XMLStreamException {
            return this.writer;
        }

        XMLStreamWriter getSerializer() {
            return this.serializer;
        }
    }
}

