/*
 * Copyright 2012-2016 MarkLogic Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.marklogic.client.eval;

import java.util.Iterator;

/** An Iterator to walk through all results returned from calls to
 * {@link ServerEvaluationCall#eval()}.
 */
public interface EvalResultIterator extends Iterable<EvalResult>, Iterator<EvalResult> {
    public Iterator<EvalResult> iterator();
    public boolean hasNext();
    public EvalResult next();
	public void close();
}
