/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.marklogic.client.DatabaseClientFactory;
import com.marklogic.client.Transaction;
import com.marklogic.client.impl.AbstractLoggingManager;
import com.marklogic.client.impl.GraphPermissionsImpl;
import com.marklogic.client.impl.HandleAccessor;
import com.marklogic.client.impl.HandleImplementation;
import com.marklogic.client.impl.RESTServices;
import com.marklogic.client.impl.Utilities;
import com.marklogic.client.io.JacksonHandle;
import com.marklogic.client.io.StringHandle;
import com.marklogic.client.io.marker.AbstractWriteHandle;
import com.marklogic.client.io.marker.ContentHandle;
import com.marklogic.client.io.marker.QuadsWriteHandle;
import com.marklogic.client.io.marker.TriplesReadHandle;
import com.marklogic.client.io.marker.TriplesWriteHandle;
import com.marklogic.client.semantics.Capability;
import com.marklogic.client.semantics.GraphManager;
import com.marklogic.client.semantics.GraphPermissions;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class GraphManagerImpl<R extends TriplesReadHandle, W extends TriplesWriteHandle>
extends AbstractLoggingManager
implements GraphManager {
    private RESTServices services;
    private DatabaseClientFactory.HandleFactoryRegistry handleRegistry;
    private String defaultMimetype;

    public GraphManagerImpl(RESTServices services, DatabaseClientFactory.HandleFactoryRegistry handleRegistry) {
        this.services = services;
        this.handleRegistry = handleRegistry;
    }

    @Override
    public Iterator<String> listGraphUris() {
        String uriString = this.services.getGraphUris(this.requestLogger, new StringHandle()).get();
        String[] uris = uriString.split("\n");
        return Arrays.asList(uris).iterator();
    }

    @Override
    public <T extends TriplesReadHandle> T read(String uri, T handle) {
        return this.read(uri, handle, null);
    }

    @Override
    public <T extends TriplesReadHandle> T read(String uri, T handle, Transaction transaction) {
        HandleImplementation baseHandle = HandleAccessor.as(handle);
        String mimetype = baseHandle.getMimetype();
        if (mimetype == null) {
            baseHandle.setMimetype(this.defaultMimetype);
        }
        this.services.readGraph(this.requestLogger, uri, handle, transaction);
        baseHandle.setMimetype(mimetype);
        return handle;
    }

    @Override
    public <T> T readAs(String uri, Class<T> as) {
        return this.readAs(uri, as, null);
    }

    @Override
    public <T> T readAs(String uri, Class<T> as, Transaction transaction) {
        ContentHandle<T> triplesHandle = this.getTriplesReadHandle(as);
        if (null == this.read(uri, (TriplesReadHandle)((Object)triplesHandle), transaction)) {
            return null;
        }
        return triplesHandle.get();
    }

    @Override
    public GraphPermissions getPermissions(String uri) {
        return this.getPermissions(uri, null);
    }

    @Override
    public GraphPermissions getPermissions(String uri, Transaction transaction) {
        JsonNode json = this.services.getPermissions(this.requestLogger, uri, new JacksonHandle(), transaction).get();
        GraphPermissionsImpl perms = new GraphPermissionsImpl();
        for (JsonNode permission : json.path("permissions")) {
            String role = permission.path("role-name").asText();
            HashSet<Capability> capabilities = new HashSet<Capability>();
            for (JsonNode capability : permission.path("capabilities")) {
                String value = capability.asText();
                if (value == null) continue;
                capabilities.add(Capability.valueOf(value.toUpperCase()));
            }
            perms.put(role, capabilities);
        }
        return perms;
    }

    @Override
    public void deletePermissions(String uri) {
        this.deletePermissions(uri, null);
    }

    @Override
    public void deletePermissions(String uri, Transaction transaction) {
        this.services.deletePermissions(this.requestLogger, uri, transaction);
    }

    private <T> ContentHandle<T> getTriplesReadHandle(Class<T> as) {
        ContentHandle<T> handle = this.handleRegistry.makeHandle(as);
        if (!(handle instanceof TriplesReadHandle)) {
            throw new IllegalArgumentException("The Class for arg \"as\" is registered by " + handle.getClass() + " which is not a TriplesReadHandle so it cannot be used by GraphManager");
        }
        return handle;
    }

    private JacksonHandle generatePermissions(GraphPermissions permissions) {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode payload = mapper.createObjectNode();
        ArrayNode permissionsNode = mapper.createArrayNode();
        payload.set("permissions", (JsonNode)permissionsNode);
        for (String role : permissions.keySet()) {
            ObjectNode permissionNode = mapper.createObjectNode();
            permissionNode.put("role-name", role);
            ArrayNode capabilitiesNode = mapper.createArrayNode();
            for (Capability capability : (Set)permissions.get(role)) {
                capabilitiesNode.add(capability.toString().toLowerCase());
            }
            permissionNode.set("capabilities", (JsonNode)capabilitiesNode);
            permissionsNode.add((JsonNode)permissionNode);
        }
        return new JacksonHandle((JsonNode)payload);
    }

    @Override
    public void writePermissions(String uri, GraphPermissions permissions) {
        this.writePermissions(uri, permissions, null);
    }

    @Override
    public void writePermissions(String uri, GraphPermissions permissions, Transaction transaction) {
        this.services.writePermissions(this.requestLogger, uri, this.generatePermissions(permissions), transaction);
    }

    @Override
    public void mergePermissions(String uri, GraphPermissions permissions) {
        this.mergePermissions(uri, permissions, null);
    }

    @Override
    public void mergePermissions(String uri, GraphPermissions permissions, Transaction transaction) {
        this.services.mergePermissions(this.requestLogger, uri, this.generatePermissions(permissions), transaction);
    }

    @Override
    public void merge(String uri, TriplesWriteHandle handle) {
        this.merge(uri, handle, null, null);
    }

    @Override
    public void merge(String uri, TriplesWriteHandle handle, Transaction transaction) {
        this.merge(uri, handle, null, transaction);
    }

    @Override
    public void merge(String uri, TriplesWriteHandle handle, GraphPermissions permissions) {
        this.merge(uri, handle, permissions, null);
    }

    @Override
    public void merge(String uri, TriplesWriteHandle handle, GraphPermissions permissions, Transaction transaction) {
        HandleImplementation baseHandle = HandleAccessor.as(handle);
        String mimetype = this.validateGraphsMimetype(baseHandle);
        this.services.mergeGraph(this.requestLogger, uri, handle, permissions, transaction);
        baseHandle.setMimetype(mimetype);
    }

    @Override
    public void mergeAs(String uri, Object graphData) {
        this.mergeAs(uri, graphData, null, null);
    }

    @Override
    public void mergeAs(String uri, Object graphData, Transaction transaction) {
        this.mergeAs(uri, graphData, null, transaction);
    }

    @Override
    public void mergeAs(String uri, Object graphData, GraphPermissions permissions) {
        this.mergeAs(uri, graphData, permissions, null);
    }

    @Override
    public void mergeAs(String uri, Object graphData, GraphPermissions permissions, Transaction transaction) {
        this.merge(uri, this.populateTriplesHandle(graphData), permissions, transaction);
    }

    @Override
    public void write(String uri, TriplesWriteHandle handle) {
        this.write(uri, handle, null, null);
    }

    @Override
    public void write(String uri, TriplesWriteHandle handle, Transaction transaction) {
        this.write(uri, handle, null, transaction);
    }

    @Override
    public void write(String uri, TriplesWriteHandle handle, GraphPermissions permissions) {
        this.write(uri, handle, permissions, null);
    }

    @Override
    public void write(String uri, TriplesWriteHandle handle, GraphPermissions permissions, Transaction transaction) {
        HandleImplementation baseHandle = HandleAccessor.as(handle);
        String mimetype = this.validateGraphsMimetype(baseHandle);
        this.services.writeGraph(this.requestLogger, uri, handle, permissions, transaction);
        baseHandle.setMimetype(mimetype);
    }

    @Override
    public void writeAs(String uri, Object graphData) {
        this.writeAs(uri, graphData, null, null);
    }

    @Override
    public void writeAs(String uri, Object graphData, Transaction transaction) {
        this.writeAs(uri, graphData, null, transaction);
    }

    @Override
    public void writeAs(String uri, Object graphData, GraphPermissions permissions) {
        this.writeAs(uri, graphData, permissions, null);
    }

    @Override
    public void writeAs(String uri, Object graphData, GraphPermissions permissions, Transaction transaction) {
        this.write(uri, this.populateTriplesHandle(graphData), permissions, transaction);
    }

    private AbstractWriteHandle populateHandle(Object graphData) {
        if (graphData == null) {
            throw new IllegalArgumentException("no graphData to write");
        }
        Class<?> as = graphData.getClass();
        if (AbstractWriteHandle.class.isAssignableFrom(as)) {
            return (AbstractWriteHandle)graphData;
        }
        ContentHandle<?> handle = this.handleRegistry.makeHandle(as);
        if (!(handle instanceof TriplesReadHandle)) {
            throw new IllegalArgumentException("Arg \"graphData\" is handled by " + handle.getClass() + " which is not a TriplesReadHandle so it cannot write using GraphManager");
        }
        Utilities.setHandleContent(handle, graphData);
        return handle;
    }

    private QuadsWriteHandle populateQuadsHandle(Object graphData) {
        return (QuadsWriteHandle)this.populateHandle(graphData);
    }

    private TriplesWriteHandle populateTriplesHandle(Object graphData) {
        return (TriplesWriteHandle)this.populateHandle(graphData);
    }

    @Override
    public void delete(String uri) {
        this.services.deleteGraph(this.requestLogger, uri, null);
    }

    @Override
    public void delete(String uri, Transaction transaction) {
        this.services.deleteGraph(this.requestLogger, uri, transaction);
    }

    @Override
    public <T extends TriplesReadHandle> T things(T handle, String ... iris) {
        if (iris == null) {
            throw new IllegalArgumentException("iris cannot be null");
        }
        return this.services.getThings(this.requestLogger, iris, handle);
    }

    @Override
    public <T> T thingsAs(Class<T> as, String ... iris) {
        ContentHandle<T> triplesHandle = this.getTriplesReadHandle(as);
        if (null == this.things((TriplesReadHandle)((Object)triplesHandle), iris)) {
            return null;
        }
        return triplesHandle.get();
    }

    @Override
    public void mergeGraphs(QuadsWriteHandle handle) {
        this.mergeGraphs(handle, null);
    }

    @Override
    public void mergeGraphs(QuadsWriteHandle handle, Transaction transaction) {
        HandleImplementation baseHandle = HandleAccessor.as(handle);
        String mimetype = this.validateGraphsMimetype(baseHandle);
        this.services.mergeGraphs(this.requestLogger, handle, transaction);
        baseHandle.setMimetype(mimetype);
    }

    @Override
    public void mergeGraphsAs(Object quadsData) {
        this.mergeGraphsAs(quadsData, null);
    }

    @Override
    public void mergeGraphsAs(Object quadsData, Transaction transaction) {
        this.mergeGraphs(this.populateQuadsHandle(quadsData), transaction);
    }

    @Override
    public void replaceGraphs(QuadsWriteHandle handle) {
        this.replaceGraphs(handle, null);
    }

    @Override
    public void replaceGraphs(QuadsWriteHandle handle, Transaction transaction) {
        HandleImplementation baseHandle = HandleAccessor.as(handle);
        String mimetype = this.validateGraphsMimetype(baseHandle);
        this.services.writeGraphs(this.requestLogger, handle, transaction);
        baseHandle.setMimetype(mimetype);
    }

    @Override
    public void replaceGraphsAs(Object quadsData) {
        this.replaceGraphsAs(quadsData, null);
    }

    @Override
    public void replaceGraphsAs(Object quadsData, Transaction transaction) {
        this.replaceGraphs(this.populateQuadsHandle(quadsData), transaction);
    }

    @Override
    public void deleteGraphs() {
        this.deleteGraphs(null);
    }

    @Override
    public void deleteGraphs(Transaction transaction) {
        this.services.deleteGraphs(this.requestLogger, transaction);
    }

    @Override
    public GraphPermissions permission(String role, Capability ... capabilities) {
        GraphPermissionsImpl perms = new GraphPermissionsImpl();
        perms.put(role, new HashSet<Capability>(Arrays.asList(capabilities)));
        return perms;
    }

    @Override
    public String getDefaultMimetype() {
        return this.defaultMimetype;
    }

    @Override
    public void setDefaultMimetype(String mimetype) {
        this.defaultMimetype = mimetype;
    }

    private String validateGraphsMimetype(HandleImplementation baseHandle) {
        String mimetype = baseHandle.getMimetype();
        if (mimetype == null) {
            if (this.defaultMimetype != null) {
                baseHandle.setMimetype(this.defaultMimetype);
            } else {
                throw new IllegalArgumentException("You must either call setMimetype on your handle or setDefaultMimetype on your GraphManager instance with a mimetype from RDFMimeTypes");
            }
        }
        return mimetype;
    }

    @Override
    public GraphPermissions newGraphPermissions() {
        return new GraphPermissionsImpl();
    }
}

