/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.function;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BooleanSupplier;

@FunctionalInterface
public interface BooleanConsumer {
    public void accept(boolean var1);

    default public Runnable toRunnable(BooleanSupplier supplier) {
        return () -> this.accept(supplier.getAsBoolean());
    }

    default public BooleanConsumer andThen(BooleanConsumer other) {
        return new BooleanConsumer(){
            List<BooleanConsumer> others = new ArrayList<BooleanConsumer>(2);

            @Override
            public void accept(boolean val) {
                BooleanConsumer.this.accept(val);
                for (BooleanConsumer b : this.others) {
                    b.accept(val);
                }
            }

            public String toString() {
                return BooleanConsumer.this + ", " + this.others;
            }

            @Override
            public BooleanConsumer andThen(BooleanConsumer other) {
                this.others.add(other);
                return this;
            }
        };
    }

    public static BooleanConsumer ifTrue(final Runnable run) {
        return new BooleanConsumer(){

            @Override
            public void accept(boolean val) {
                if (val) {
                    run.run();
                }
            }

            public String toString() {
                return "ifTrue(" + run + ")";
            }
        };
    }

    public static BooleanConsumer ifFalse(final Runnable run) {
        return new BooleanConsumer(){

            @Override
            public void accept(boolean val) {
                if (!val) {
                    run.run();
                }
            }

            public String toString() {
                return "ifTrue(" + run + ")";
            }
        };
    }
}

