/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.function;

import java.util.Arrays;
import java.util.function.IntPredicate;

@FunctionalInterface
public interface BytePredicate {
    public boolean test(byte var1);

    public static BytePredicate fromSignedIntPredicate(final IntPredicate pred) {
        return new BytePredicate(){

            @Override
            public boolean test(byte value) {
                return pred.test(value & 0xFF);
            }

            public String toString() {
                return "signedInt(" + pred + ")";
            }
        };
    }

    default public BytePredicate and(final BytePredicate other) {
        return new BytePredicate(){

            @Override
            public boolean test(byte b) {
                return BytePredicate.this.test(b) && other.test(b);
            }

            public String toString() {
                return BytePredicate.this.toString() + " & " + other.toString();
            }
        };
    }

    default public BytePredicate or(final BytePredicate other) {
        return new BytePredicate(){

            @Override
            public boolean test(byte b) {
                return BytePredicate.this.test(b) || other.test(b);
            }

            public String toString() {
                return BytePredicate.this.toString() + " | " + other.toString();
            }
        };
    }

    default public BytePredicate xor(final BytePredicate other) {
        return new BytePredicate(){

            @Override
            public boolean test(byte b) {
                return BytePredicate.this.test(b) != other.test(b);
            }

            public String toString() {
                return BytePredicate.this.toString() + " ~ " + other.toString();
            }
        };
    }

    default public BytePredicate negate() {
        return new BytePredicate(){

            @Override
            public boolean test(byte b) {
                return !BytePredicate.this.test(b);
            }

            public String toString() {
                return "!" + BytePredicate.this.toString();
            }
        };
    }

    public static BytePredicate of(final byte val) {
        return new BytePredicate(){

            @Override
            public boolean test(byte b) {
                return val == b;
            }

            public String toString() {
                return "equalTo(" + val + ")";
            }
        };
    }

    public static BytePredicate anyOf(final byte val, final byte ... moreVals) {
        Arrays.sort(moreVals);
        return new BytePredicate(){

            @Override
            public boolean test(byte value) {
                return value == val || Arrays.binarySearch(moreVals, value) >= 0;
            }

            public String toString() {
                StringBuilder sb = new StringBuilder().append("anyOf(").append(val);
                if (moreVals.length > 0) {
                    sb.append(",");
                }
                for (int i = 0; i < moreVals.length; ++i) {
                    sb.append(moreVals[i]);
                    if (i >= moreVals.length - 1) continue;
                    sb.append(',');
                }
                return sb.append(')').toString();
            }
        };
    }

    public static BytePredicate noneOf(final byte val, final byte ... moreVals) {
        Arrays.sort(moreVals);
        return new BytePredicate(){

            @Override
            public boolean test(byte value) {
                return value != val && Arrays.binarySearch(moreVals, value) < 0;
            }

            public String toString() {
                StringBuilder sb = new StringBuilder("noneOf(").append(val);
                if (moreVals.length > 0) {
                    sb.append(",");
                }
                for (int i = 0; i < moreVals.length; ++i) {
                    sb.append(moreVals[i]);
                    if (i >= moreVals.length - 1) continue;
                    sb.append(',');
                }
                return sb.append(')').toString();
            }
        };
    }
}

