/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.function;

import com.mastfrog.function.EnhDoubleUnaryOperator;
import com.mastfrog.function.EnhIntSupplier;
import java.util.function.DoubleSupplier;
import java.util.function.DoubleUnaryOperator;

public interface EnhDoubleSupplier
extends DoubleSupplier {
    public static EnhDoubleSupplier fixed(double val) {
        return () -> val;
    }

    default public EnhDoubleSupplier andThen(DoubleUnaryOperator op) {
        return () -> op.applyAsDouble(this.getAsDouble());
    }

    default public EnhDoubleSupplier plus(DoubleSupplier supp) {
        return () -> this.getAsDouble() + supp.getAsDouble();
    }

    default public EnhDoubleSupplier minus(DoubleSupplier supp) {
        return () -> this.getAsDouble() - supp.getAsDouble();
    }

    default public EnhDoubleSupplier times(DoubleSupplier supp) {
        return () -> this.getAsDouble() * supp.getAsDouble();
    }

    default public EnhDoubleSupplier mod(DoubleSupplier supp) {
        return () -> this.getAsDouble() % supp.getAsDouble();
    }

    default public EnhDoubleSupplier dividedBy(DoubleSupplier supp) {
        return () -> this.getAsDouble() / supp.getAsDouble();
    }

    default public EnhDoubleSupplier dividedInto(DoubleSupplier supp) {
        return () -> supp.getAsDouble() / this.getAsDouble();
    }

    default public EnhDoubleSupplier plus(double val) {
        return () -> this.getAsDouble() + val;
    }

    default public EnhDoubleSupplier minus(double val) {
        return () -> this.getAsDouble() - val;
    }

    default public EnhDoubleSupplier times(double val) {
        return () -> this.getAsDouble() * val;
    }

    default public EnhDoubleSupplier mod(double val) {
        return () -> this.getAsDouble() % val;
    }

    default public EnhDoubleSupplier dividedBy(double val) {
        return () -> this.getAsDouble() / val;
    }

    default public EnhDoubleSupplier dividedInto(double val) {
        return () -> val / this.getAsDouble();
    }

    default public EnhDoubleSupplier abs() {
        return this.andThen(Math::abs);
    }

    default public EnhIntSupplier toIntSupplier(Conversion conversion) {
        return conversion.toIntSupplier(this);
    }

    default public EnhIntSupplier toIntSupplier() {
        return this.toIntSupplier(Conversion.FLOOR);
    }

    default public EnhDoubleSupplier ifNonFinite(DoubleSupplier supp) {
        return () -> {
            double result = this.getAsDouble();
            if (!Double.isFinite(result)) {
                result = supp.getAsDouble();
            }
            return result;
        };
    }

    public static enum Conversion implements EnhDoubleUnaryOperator
    {
        ROUND,
        CEIL,
        FLOOR;


        @Override
        public double applyAsDouble(double operand) {
            switch (this) {
                case ROUND: {
                    return Math.round(operand);
                }
                case CEIL: {
                    return Math.ceil(operand);
                }
                case FLOOR: {
                    return Math.floor(operand);
                }
            }
            throw new AssertionError(this);
        }

        EnhIntSupplier toIntSupplier(EnhDoubleSupplier supplier) {
            return () -> (int)this.applyAsDouble(supplier.getAsDouble());
        }
    }
}

