/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.function;

import java.util.Objects;
import java.util.function.DoubleUnaryOperator;

public interface EnhDoubleUnaryOperator
extends DoubleUnaryOperator {
    default public EnhDoubleUnaryOperator fixed(double val) {
        return ignored -> val;
    }

    default public EnhDoubleUnaryOperator times(double val) {
        return this.andThen(v -> v * val);
    }

    default public EnhDoubleUnaryOperator dividedBy(double val) {
        if (val == 0.0) {
            throw new IllegalArgumentException("Will divide by 0");
        }
        return this.andThen(v -> v / val);
    }

    default public EnhDoubleUnaryOperator divideInto(double val) {
        return this.andThen(v -> val / v);
    }

    default public EnhDoubleUnaryOperator plus(double val) {
        return this.andThen(v -> v + val);
    }

    default public EnhDoubleUnaryOperator minus(double val) {
        return this.andThen(v -> v - val);
    }

    default public EnhDoubleUnaryOperator mod(double val) {
        return this.andThen(v -> v - val);
    }

    default public EnhDoubleUnaryOperator negate() {
        return v -> -v;
    }

    @Override
    default public EnhDoubleUnaryOperator andThen(DoubleUnaryOperator after) {
        Objects.requireNonNull(after);
        return t -> after.applyAsDouble(this.applyAsDouble(t));
    }

    @Override
    default public EnhDoubleUnaryOperator compose(DoubleUnaryOperator before) {
        Objects.requireNonNull(before);
        return v -> this.applyAsDouble(before.applyAsDouble(v));
    }
}

