/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.function;

import com.mastfrog.function.EnhDoubleSupplier;
import java.util.function.IntPredicate;
import java.util.function.IntSupplier;
import java.util.function.IntUnaryOperator;
import java.util.function.Supplier;

@FunctionalInterface
public interface EnhIntSupplier
extends IntSupplier {
    default public EnhIntSupplier or(IntPredicate test, IntSupplier next) {
        return () -> {
            int result = this.getAsInt();
            return test.test(result) ? result : next.getAsInt();
        };
    }

    default public EnhIntSupplier ifZero(IntSupplier next) {
        return () -> {
            int result = this.getAsInt();
            return result == 0 ? next.getAsInt() : result;
        };
    }

    default public EnhIntSupplier plus(IntSupplier next) {
        return () -> this.getAsInt() + next.getAsInt();
    }

    default public EnhIntSupplier times(IntSupplier next) {
        return () -> {
            int result = this.getAsInt();
            return result == 0 ? 0 : result * next.getAsInt();
        };
    }

    default public EnhIntSupplier minus(IntSupplier next) {
        return () -> this.getAsInt() - next.getAsInt();
    }

    default public EnhIntSupplier mod(IntSupplier next) {
        return () -> this.getAsInt() % next.getAsInt();
    }

    default public EnhIntSupplier bitwiseOr(IntSupplier next) {
        return () -> this.getAsInt() | next.getAsInt();
    }

    default public EnhIntSupplier bitwiseXor(IntSupplier next) {
        return () -> this.getAsInt() ^ next.getAsInt();
    }

    default public EnhIntSupplier bitwiseAnd(IntSupplier next) {
        return () -> this.getAsInt() & next.getAsInt();
    }

    default public EnhIntSupplier dividedBy(IntSupplier next) {
        return () -> {
            int result = this.getAsInt();
            int div = next.getAsInt();
            return result == 0 || div == 0 ? 0 : result / div;
        };
    }

    default public EnhIntSupplier andThen(IntUnaryOperator op) {
        return () -> op.applyAsInt(this.getAsInt());
    }

    default public EnhIntSupplier abs() {
        return this.andThen(Math::abs);
    }

    default public EnhIntSupplier plus(int val) {
        return () -> this.getAsInt() + val;
    }

    default public EnhIntSupplier minus(int val) {
        return () -> this.getAsInt() - val;
    }

    default public EnhIntSupplier times(int val) {
        return () -> this.getAsInt() * val;
    }

    default public EnhIntSupplier mod(int val) {
        return () -> this.getAsInt() % val;
    }

    default public EnhIntSupplier dividedBy(int val) {
        return () -> this.getAsInt() / val;
    }

    default public EnhIntSupplier dividedInto(int val) {
        return () -> val / this.getAsInt();
    }

    default public EnhDoubleSupplier plus(double val) {
        return () -> (double)this.getAsInt() + val;
    }

    default public EnhDoubleSupplier minus(double val) {
        return () -> (double)this.getAsInt() - val;
    }

    default public EnhDoubleSupplier times(double val) {
        return () -> (double)this.getAsInt() * val;
    }

    default public EnhDoubleSupplier mod(double val) {
        return () -> (double)this.getAsInt() % val;
    }

    default public EnhDoubleSupplier dividedBy(double val) {
        return () -> (double)this.getAsInt() / val;
    }

    default public EnhDoubleSupplier dividedInto(double val) {
        return () -> val / (double)this.getAsInt();
    }

    public static EnhIntSupplier wrap(IntSupplier supp) {
        if (supp instanceof EnhIntSupplier) {
            return (EnhIntSupplier)supp;
        }
        return () -> supp.getAsInt();
    }

    default public Supplier<Integer> toBoxedSupplier() {
        return () -> this.getAsInt();
    }
}

