/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.function;

import com.mastfrog.function.DoubleBiFunction;
import com.mastfrog.function.FloatSupplier;
import java.util.function.Supplier;

@FunctionalInterface
public interface FloatBiFunction<T> {
    public T apply(float var1, float var2);

    default public Supplier<T> toSupplier(FloatSupplier sa, FloatSupplier sb) {
        return () -> this.apply(sa.getAsFloat(), sb.getAsFloat());
    }

    default public DoubleBiFunction<T> toDoubleBiFunction() {
        return (a, b) -> {
            if (a > 3.4028234663852886E38 || a < (double)Float.MIN_VALUE) {
                throw new IllegalArgumentException("Value out of range for float: " + a);
            }
            if (b > 3.4028234663852886E38 || b < (double)Float.MIN_VALUE) {
                throw new IllegalArgumentException("Value out of range for float: " + b);
            }
            return this.apply((float)a, (float)b);
        };
    }

    public static <T> FloatBiFunction<T> fromDoubleFunction(DoubleBiFunction<T> df) {
        return (a, b) -> df.apply(a, b);
    }
}

