/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.function;

import com.mastfrog.function.FloatSupplier;
import java.util.function.DoubleFunction;
import java.util.function.Supplier;

@FunctionalInterface
public interface FloatFunction<T> {
    public T apply(float var1);

    default public FloatFunction<T> filterNaN() {
        return val -> {
            if (Float.isNaN(val)) {
                return null;
            }
            return this.apply(val);
        };
    }

    default public FloatFunction<T> filterNonFinite() {
        return val -> {
            if (!Float.isFinite(val)) {
                return null;
            }
            return this.apply(val);
        };
    }

    default public Supplier<T> toSupplier(FloatSupplier supp) {
        return () -> this.apply(supp.getAsFloat());
    }

    default public DoubleFunction<T> toDoubleFunction() {
        return dbl -> {
            if (dbl > 3.4028234663852886E38 || dbl < (double)Float.MIN_VALUE) {
                throw new IllegalArgumentException("Value out of range for float: " + dbl);
            }
            return this.apply((float)dbl);
        };
    }

    public static <T> FloatFunction<T> fromDoubleFunction(DoubleFunction<T> df) {
        return val -> df.apply(val);
    }
}

